﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;

namespace LayoutEditor.Controls
{

    public partial class UISplitContainer :
        SplitContainer,
        ILESerializableControl
    {
        //----------------------------------------------------
        #region 定数
        const string SplitterDistanceStr_ = "_SplitterDistance";
        const string SplitterPanel1CollapsedStr_ = "_Panel1Collapsed";
        const string SplitterPanel2CollapsedStr_ = "_Panel2Collapsed";
        #endregion 定数

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public UISplitContainer()
        {
            InitializeComponent();
        }

        //----------------------------------------------------
        #region ILESerializableControl メンバ

        /// <summary>
        ///
        /// </summary>
        public void SaveState( out LEControlUserDataChunk[] dataSet )
        {
            dataSet = new LEControlUserDataChunk[3];
            dataSet[0] = new LEControlUserDataChunk( this.Name + SplitterDistanceStr_, this.SplitterDistance.ToString() );
            dataSet[1] = new LEControlUserDataChunk( this.Name + SplitterPanel1CollapsedStr_, this.Panel1Collapsed.ToString() );
            dataSet[2] = new LEControlUserDataChunk( this.Name + SplitterPanel2CollapsedStr_, this.Panel2Collapsed.ToString() );
        }

        /// <summary>
        ///
        /// </summary>
        bool FindDataByParamaterName_(
            LEControlUserDataChunk[] dataSet,
            string paramaterName,
            out LEControlUserDataChunk userData)
        {
            userData = Array.Find( dataSet, delegate( LEControlUserDataChunk data )
            {
                return data.Name == this.Name + paramaterName;
            } );

            return userData != null;
        }

        /// <summary>
        ///
        /// </summary>
        public void LoadState( LEControlUserDataChunk[] dataSet )
        {
            LEControlUserDataChunk userData;

            if( FindDataByParamaterName_( dataSet, SplitterPanel1CollapsedStr_, out userData ) )
            {
                this.Panel1Collapsed = bool.Parse( userData.Value );
            }

            if( FindDataByParamaterName_( dataSet, SplitterPanel2CollapsedStr_, out userData ) )
            {
                this.Panel2Collapsed = bool.Parse( userData.Value );
            }

            if( FindDataByParamaterName_( dataSet, SplitterDistanceStr_, out userData ) )
            {
                if (!this.IsSplitterFixed)
                {
                    this.SplitterDistance = int.Parse(userData.Value);
                }
            }
        }

        #endregion
    }
}
