﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.ComponentModel;
using System.Collections;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Windows.Forms;
using System.Windows.Forms.Design;

namespace LayoutEditor.Controls
{
    /// <summary>
    /// ＵＩラジオボタンクラス。
    /// </summary>
    [ToolboxBitmap(typeof(RadioButton))]
    public class UIRadioButton : RadioButton
    {
        private static bool _invokeEvent = true;

        /// <summary>ラジオチェックイベント。</summary>
        public event EventHandler RadioChecked = null;

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public UIRadioButton()
        {
            // this.FlatStyle = FlatStyle.System;
        }

        /// <summary>
        /// 再定義。
        /// </summary>
        [DefaultValue(FlatStyle.System)]
        public new FlatStyle FlatStyle
        {
            get { return base.FlatStyle;  }
            set { base.FlatStyle = value; }
        }

        /// <summary>
        /// Checkedプロパティ設定。
        /// </summary>
        public void SetChecked(bool val)
        {
            _invokeEvent = false;
            {
                this.Checked = val;
            }
            _invokeEvent = true;
        }

        /// <summary>
        /// CheckedプロパティをTag値比較で設定。
        /// </summary>
        public void SetCheckedByTag(object tag)
        {
            _invokeEvent = false;
            {
                if (this.Tag != null)
                {
                    bool flag = this.Tag.Equals(tag);
                    if(this.Checked != flag)
                    {
                        this.Checked = flag;
                    }
                }
            }
            _invokeEvent = true;
        }

        /// <summary>
        /// ラジオチェックハンドラ。
        /// </summary>
        protected virtual void OnRadioChecked(EventArgs e)
        {
            if (this.RadioChecked != null)
            {
                RadioChecked(this, e);
            }
        }

        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override void OnCheckedChanged(EventArgs e)
        {
            if (_invokeEvent)
            {
                // RadioCheckedイベント
                if (this.Checked)
                {
                    OnRadioChecked(e);
                }
                base.OnCheckedChanged(e);
            }
        }

        private void InitializeComponent()
        {
            this.SuspendLayout();
            this.ResumeLayout( false );

        }
    }
}
