﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.ComponentModel;
using System.Collections;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Windows.Forms;
using System.Windows.Forms.Design;

namespace LayoutEditor.Controls
{
    /// <summary>
    /// ＵＩリストボックスクラス。
    /// </summary>
    public class UIListBox : ListBox
    {
        private static bool _invokeEvent      = true;
        private int         _preSelectedIndex = -1;

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public UIListBox()
        {
        }

        /// <summary>
        /// 選択項目データ。
        /// </summary>
        [Browsable(false)]
        public object SelectedItemData
        {
            get
            {
                UIListControlItem item = this.SelectedItem as UIListControlItem;
                if (item != null)
                {
                    return item.Data;
                }
                return null;
            }
            set
            {
                if (value != null)
                {
                    foreach (object item in this.Items)
                    {
                        UIListControlItem listItem = item as UIListControlItem;
                        if (listItem != null && listItem.Data.Equals(value))
                        {
                            this.SelectedItem = item;
                            return;
                        }
                    }
                }
            }
        }

        /// <summary>
        /// 項目追加。
        /// </summary>
        public void AddItem(string text, object data)
        {
            this.Items.Add(new UIListControlItem(text, data, false));
        }

        /// <summary>
        /// 項目追加。
        /// </summary>
        public void AddItem(string text, object data, bool textIsStringID)
        {
            this.Items.Add(new UIListControlItem(text, data, textIsStringID));
        }

        /// <summary>
        /// SelectedIndexプロパティ設定。
        /// </summary>
        public void SetSelectedIndex(int val)
        {
            _invokeEvent = false;
            {
                this.SelectedIndex = val;
            }
            _invokeEvent = true;
        }

        /// <summary>
        /// SelectedItemプロパティ設定。
        /// </summary>
        public void SetSelectedItem(object val)
        {
            _invokeEvent = false;
            {
                this.SelectedItem = val;
            }
            _invokeEvent = true;
        }

        /// <summary>
        /// SelectedItemDataプロパティ設定。
        /// </summary>
        public void SetSelectedItemData(object val)
        {
            _invokeEvent = false;
            {
                this.SelectedItemData = val;
            }
            _invokeEvent = true;
        }

        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override void OnSelectedIndexChanged(EventArgs e)
        {
            if (_invokeEvent && (_preSelectedIndex != SelectedIndex))
            {
                base.OnSelectedIndexChanged(e);
            }
            _preSelectedIndex = SelectedIndex;
        }

        private void InitializeComponent()
        {
            this.SuspendLayout();
            this.ResumeLayout( false );

        }
    }
}
