﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.ComponentModel;
using System.Collections;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Windows.Forms;
using System.Windows.Forms.Design;

namespace LayoutEditor.Controls
{
    /// <summary>
    /// ＵＩチェックボックスクラス。
    /// </summary>
    [ToolboxBitmap(typeof(CheckBox))]
    public class UICheckBox : CheckBox
    {
        private static bool _invokeEvent = true;

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public UICheckBox()
        {
            this.FlatStyle = FlatStyle.System;
        }

        /// <summary>
        /// 再定義。
        /// </summary>
        [DefaultValue(FlatStyle.System)]
        public new FlatStyle FlatStyle
        {
            get { return base.FlatStyle;  }
            set { base.FlatStyle = value; }
        }

        /// <summary>
        /// Checkedプロパティ設定。
        /// </summary>
        public void SetChecked(bool val)
        {
            _invokeEvent = false;
            {
                this.Checked = val;
            }
            _invokeEvent = true;
        }

        /// <summary>
        /// CheckStateプロパティ設定。
        /// </summary>
        public void SetCheckState(CheckState val)
        {
            _invokeEvent = false;
            {
                this.CheckState = val;
            }
            _invokeEvent = true;
        }

        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override void OnCheckedChanged(EventArgs e)
        {
            if (_invokeEvent)
            {
                base.OnCheckedChanged(e);
            }
        }

        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override void OnCheckStateChanged(EventArgs e)
        {
            if (_invokeEvent)
            {
                base.OnCheckStateChanged(e);
            }
        }

        private void InitializeComponent()
        {
            this.SuspendLayout();
            this.ResumeLayout( false );

        }
    }
}
