﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;

namespace LayoutEditor.Controls
{
    /// <summary>
    /// エディットスライダクラス。
    /// </summary>
    public class EditSlider : UserControl
    {
        #region デザイナ変数

        private System.ComponentModel.Container components = null;
        #endregion

        #region デザイナコード
        /// <summary>
        /// デザイナ サポートに必要なメソッドです。このメソッドの内容を
        /// コード エディタで変更しないでください。
        /// </summary>
        private void InitializeComponent()
        {
            //
            // EditSlider
            //
            this.Font = new System.Drawing.Font("Tahoma", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
            this.Name = "EditSlider";
            this.Size = new System.Drawing.Size(240, 40);

        }
        #endregion

        internal const EditSliderTextBoxSize   _defTextBoxSize   = EditSliderTextBoxSize.Size64;
        internal const EditSliderTextBoxMargin _defTextBoxMargin = EditSliderTextBoxMargin.Size8;

        /// <summary>範囲ラベルの可視</summary>
        protected bool _showRangeLabel = true;
        /// <summary>テキストボックスサイズ</summary>
        protected EditSliderTextBoxSize _textBoxSize = _defTextBoxSize;
        /// <summary>テキストボックスマージン</summary>
        protected EditSliderTextBoxMargin _textBoxMargin = _defTextBoxMargin;

        /// <summary>値編集イベント</summary>
        public event ValueEditEventHandler ValueEdit = null;

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public EditSlider()
        {
            InitializeComponent();
        }

        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override Size DefaultSize
        {
            get { return new Size(240, 40); }
        }

        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                if (components != null)
                {
                    components.Dispose();
                }
            }
            base.Dispose(disposing);
        }

        /// <summary>
        /// 値編集ハンドラ。
        /// </summary>
        protected virtual void OnValueEdit(ValueEditEventArgs e)
        {
            if (this.ValueEdit != null)
            {
                this.ValueEdit(this, e);
            }
        }
    }

    #region EditSliderTextBoxSize
    /// <summary>
    /// エディットスライダテキストボックスサイズ。
    /// </summary>
    public enum EditSliderTextBoxSize
    {
        /// <summary>40</summary>
        Size40	= 40,
        /// <summary>48</summary>
        Size48	= 48,
        /// <summary>56</summary>
        Size56	= 56,
        /// <summary>64</summary>
        Size64	= 64,
        /// <summary>72</summary>
        Size72	= 72,
        /// <summary>80</summary>
        Size80	= 80,
        /// <summary>88</summary>
        Size88	= 88,
    }
    #endregion

    #region EditSliderTextBoxMargin
    /// <summary>
    /// エディットスライダテキストボックスマージン。
    /// </summary>
    public enum EditSliderTextBoxMargin
    {
        /// <summary>8</summary>
        Size8	= 8,
        /// <summary>16</summary>
        Size16	= 16,
        /// <summary>24</summary>
        Size24	= 24,
        /// <summary>32</summary>
        Size32	= 32,
    }
    #endregion

    #region ValueEditEvent
    /// <summary>
    /// 値編集イベントハンドラデリゲート。
    /// </summary>
    public delegate void ValueEditEventHandler(object sender, ValueEditEventArgs e);

    /// <summary>
    /// 値編集イベントデータクラス。
    /// </summary>
    public sealed class ValueEditEventArgs : EventArgs
    {
        private readonly bool _editFixed;

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public ValueEditEventArgs(bool editFixed)
        {
            _editFixed = editFixed;
        }

        /// <summary>
        /// 編集確定。
        /// </summary>
        public bool EditFixed
        {
            get { return _editFixed; }
        }
    }
    #endregion
}
