﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace LayoutEditor.Controls
{
    // DockPanel Suite でドッキングが変わるとツールチップが表示されなくなる不具合に対処したツールチップ
    public partial class DockContentToolTip : ToolTip
    {
        public DockContentToolTip()
        {
            InitializeComponent();
        }

        public DockContentToolTip(IContainer container)
        {
            container.Add(this);

            InitializeComponent();
        }

        private HashSet<Control> controls = new HashSet<Control>();
        private HashSet<Control> visibleChangedControls = new HashSet<Control>();

        // ツールチップの設定
        // new で書き換えているので要注意
        public new void SetToolTip(Control control, string message)
        {
            if (string.IsNullOrEmpty(message))
            {
                control.VisibleChanged -= Control_VisibleChanged;
                controls.Remove(control);
            }
            else if (!controls.Contains(control))
            {
                controls.Add(control);
                control.VisibleChanged += Control_VisibleChanged;
            }

            ((ToolTip)this).SetToolTip(control, message);
        }

        private void Control_VisibleChanged(object sender, EventArgs e)
        {
            Debug.Assert(sender is Control);
            var control = sender as Control;
            if (control != null && control.Visible && !visibleChangedControls.Contains(control))
            {
                // 理由は不明だが VisibleChanged 直後はツールチップを再設定しても
                // ツールチップが表示されないことがある
                visibleChangedControls.Add(control);
                control.MouseMove += Control_MouseMove;
            }
        }

        private void Control_MouseMove(object sender, MouseEventArgs e)
        {
            Debug.Assert(sender is Control);
            var control = sender as Control;
            if (control != null)
            {
                // 既定クラスの SetToolTip を呼ぶためにキャストする
                var toolTip = (ToolTip)this;
                var message = toolTip.GetToolTip(control);

                // 一旦 null を設定して設定してツールチップを解除する
                toolTip.SetToolTip(control, null);

                // ツールチップを再設定する
                toolTip.SetToolTip(control, message);

                visibleChangedControls.Remove(control);
                control.MouseMove -= Control_MouseMove;
            }
        }
    }
}
