﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Diagnostics;
using System.Data;
using System.Text;
using System.Windows.Forms;

namespace LayoutEditor.Controls
{
    /// <summary>
    /// 互換性警告アイコン表示ピクチャボックス
    /// </summary>
    public partial class CompatibilityAlertBox : UIPictureBox
    {
        #region
        static UIPictureBox.GetVisiblityFlagHandler _GetVisiblityFlagHandler;
        static readonly Image _WarningImage = SystemIcons.Warning.ToBitmap();
        #endregion

        /// <summary>
        /// ツールチップが表示する、詳細な説明文字列
        /// </summary>
        [DefaultValue( "" )]
        [Browsable( true )]
        [Localizable( true )]
        public string ToolTipText
        {
            set
            {
                this._ttpMain.SetToolTip( this, value );
            }

            get
            {
                return _ttpMain.GetToolTip( this );
            }
        }

        /// <summary>
        /// クラス共通のハンドラを初期化します。
        /// 最初のインスタンス生成前に実行する必要があります。
        /// </summary>
        static public void InitializeGetVisiblityFlagHandler(
            UIPictureBox.GetVisiblityFlagHandler handler )
        {
            UIHelper.UIAssert( handler != null );
            UIHelper.UIAssert( _GetVisiblityFlagHandler == null );

            _GetVisiblityFlagHandler = handler;
        }



        /// <summary>
        /// コンストラクタ
        /// </summary>
        public CompatibilityAlertBox()
        {
            UIHelper.UIAssert( _GetVisiblityFlagHandler != null );

            this.BackgroundImage = _WarningImage;

            base.InitializeGetVisiblityHandler( _GetVisiblityFlagHandler );
            InitializeComponent();

            this.Size = new Size( 16, 16 );
            _ttpMain.ToolTipTitle = StringResMgr.Get( "SYSTEM_COMPATIVILITYALERT_TOOLTIP_TITLE" );
            _ttpMain.SetToolTip( this, StringResMgr.Get( "SYSTEM_COMPATIVILITYALERT_TOOLTIP_DEFAULT" ) );

            // 非常時時には、ツールチップを無効にします。
            if( _GetVisiblityFlagHandler != null )
            {
                _ttpMain.Active = _GetVisiblityFlagHandler();
            }
        }

        /// <summary>
        /// クリック
        /// </summary>
        private void CompatibilityAlertBox_Click( object sender, EventArgs e )
        {
            // ツールチップを表示します。
            LECore.DbgConsole.WriteLine( "CompatibilityAlertBox_Click" );

            _ttpMain.Active = _GetVisiblityFlagHandler();
            _ttpMain.Show( _ttpMain.GetToolTip( this ), this );
        }

        /// <summary>
        /// MouseHover
        /// </summary>
        private void CompatibilityAlertBox_MouseHover( object sender, EventArgs e )
        {
            // ツールチップを明示的に表示します。
            // 既定の処理では、ある条件下で、MouseHoverによる
            // 表示が行われなくなってしまうためです。
            _ttpMain.Active = _GetVisiblityFlagHandler();
            _ttpMain.Show( _ttpMain.GetToolTip( this ), this );
        }
    }
}
