﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using LECore.Structures.Core;
using System.Diagnostics;
using LayoutEditor.Forms.ToolWindows;

namespace LayoutEditor.src.Controls
{
    public partial class AnimationMarkFloatTextBox : UserControl
        , IAnimationMarkUsable
    {
        #region イベント

        public event EventHandler TextBoxValueChanged
        {
            add { _tbxTextBox.ValueChanged += value; }
            remove { _tbxTextBox.ValueChanged -= value; }
        }

        #endregion

        #region フィールド

        private bool _useAnimationMark = false;

        #endregion

        #region プロパティ

        /// <summary>
        /// アニメーションマーク
        /// </summary>
        public AnimationMark AnimationMarkInst
        {
            get { return _pnlMark; }
        }

        /// <summary>
        /// テキストボックス
        /// </summary>
        public LayoutEditor.Controls.FloatTextBox TextBox
        {
            get { return _tbxTextBox; }
        }

        /// <summary>
        /// テキストボックスのサイズ
        /// </summary>
        public Size TextBoxSize
        {
            get { return _tbxTextBox.Size; }
            set { _tbxTextBox.Size = value; }
        }

        /// <summary>
        /// アニメーションマークのサイズ
        /// </summary>
        public Size AnimationMarkSize
        {
            get { return _pnlMark.Size; }
            set { _pnlMark.Size = value; }
        }

        /// <summary>
        /// アニメーションマークとテキストボックスの間のマージン
        /// </summary>
        public int SplitMargin
        {
            get { return _tbxTextBox.Location.X - (_pnlMark.Location.X + _pnlMark.Size.Width); }
        }

        /// <summary>
        /// コントロールのアクセスできる役割を取得または設定します
        /// </summary>
        public AccessibleRole TextBoxAccessibleRole
        {
            get { return _tbxTextBox.AccessibleRole; }
            set { _tbxTextBox.AccessibleRole = value; }
        }

        /// <summary>
        /// 書式指定フォーマット
        /// </summary>
        public string TextBoxFormat
        {
            get { return _tbxTextBox.Format; }
            set { _tbxTextBox.Format = value; }
        }

        /// <summary>
        /// 最大値
        /// </summary>
        public float TextBoxMaxValue
        {
            get { return _tbxTextBox.MaxValue; }
            set { _tbxTextBox.MaxValue = value; }
        }

        /// <summary>
        /// 最小値
        /// </summary>
        public float TextBoxMinValue
        {
            get { return _tbxTextBox.MinValue; }
            set { _tbxTextBox.MinValue = value; }
        }

        /// <summary>
        /// テキスト
        /// </summary>
        public float TextBoxValue
        {
            get { return _tbxTextBox.Value; }
            set { _tbxTextBox.Value = value; }
        }

        /// <summary>
        /// テキストをどのように配置するか
        /// </summary>
        public HorizontalAlignment TextBoxAlign
        {
            get { return _tbxTextBox.TextAlign; }
            set { _tbxTextBox.TextAlign = value; }
        }

        /// <summary>
        /// テキストボックスの背景色
        /// </summary>
        public Color TextBoxBackColor
        {
            get { return _tbxTextBox.BackColor; }
            set { _tbxTextBox.BackColor = value; }
        }

        #endregion

        public AnimationMarkFloatTextBox()
        {
            InitializeComponent();
        }

        /// <summary>
        /// ViewManagerへのメッセージハンドラを設定します。
        /// </summary>
        public void SetViewManagerMessageHandler(Action<ViewManagerMessage> handler)
        {
            _pnlMark.SendMessageToViewManager = handler;
        }

        /// <summary>
        /// コンテキストメニューを追加します。
        /// </summary>
        public void RegistContextMenu(string name, Image image, EventHandler handler)
        {
            _pnlMark.RegistContextMenu(name, image, handler);
        }

        /// <summary>
        /// 操作対象のアトリビュートを設定します
        /// </summary>
        public void SetTargetAttribute(IAnmAttribute attr)
        {
            Debug.Assert(attr.NumSubAttribute == 0);

            _pnlMark.SetTargetAttribute(attr);
        }
        public void SetTargetAttribute(IAnmAttribute[] attrs)
        {
            _pnlMark.ClearTargetAttribute();

            foreach (IAnmAttribute attr in attrs)
            {
                Debug.Assert(attr.NumSubAttribute == 0);

                _pnlMark.AddTargetAttribute(attr);
            }
        }

        /// <summary>
        /// アニメーションマークの色を更新します
        /// </summary>
        public void UpdateMarkColor()
        {
            _pnlMark.UpdateMarkColor();
        }

        /// <summary>
        /// コンテキストメニューを更新します
        /// </summary>
        public void UpdateContextMenu()
        {
            _pnlMark.UpdateContextMenu();
        }

        /// <summary>
        /// Valueプロパティ設定。
        /// </summary>
        public void SetValue(float val)
        {
            _tbxTextBox.SetValue(val);
        }

        #region IAnimationMarkUsableメンバ

        /// <summary>
        /// アニメーションマークを利用するか
        /// </summary>
        public bool UseAnimationMark
        {
            get { return _useAnimationMark; }
            set
            {
                _useAnimationMark = value;
                _pnlMark.Visible = value;
            }
        }

        /// <summary>
        /// アニメーションマークを更新します
        /// </summary>
        public void UpdateAnimationMark()
        {
            UpdateMarkColor();
            UpdateContextMenu();
        }

        #endregion
    }
}
