﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Drawing;

namespace LECore.Win32
{
    /// <summary>
    /// ユーティリティクラス。
    /// </summary>
    public static class Utility
    {
        /// <summary>
        /// 下位16ビットを取得。
        /// </summary>
        public static int LOWORD(int n)
        {
            return (n & 0xffff);
        }

        /// <summary>
        /// 下位16ビットを取得。
        /// </summary>
        public static int LOWORD(IntPtr p)
        {
            return LOWORD((int)(long)p);
        }

        /// <summary>
        /// 上位16ビットを取得。
        /// </summary>
        public static int HIWORD(int n)
        {
            return ((n >> 0x10) & 0xffff);
        }

        /// <summary>
        /// 上位16ビットを取得。
        /// </summary>
        public static int HIWORD(IntPtr p)
        {
            return HIWORD((int)(long)p);
        }

        /// <summary>
        /// 符号付き下位16ビットを取得。
        /// </summary>
        public static int SignedLOWORD(int n)
        {
            return (short)(n & 0xffff);
        }

        /// <summary>
        /// 符号付き下位16ビットを取得。
        /// </summary>
        public static int SignedLOWORD(IntPtr p)
        {
            return SignedLOWORD((int)(long)p);
        }

        /// <summary>
        /// 符号付き上位16ビットを取得。
        /// </summary>
        public static int SignedHIWORD(int n)
        {
            return (short)((n >> 0x10) & 0xffff);
        }

        /// <summary>
        /// 符号付き上位16ビットを取得。
        /// </summary>
        public static int SignedHIWORD(IntPtr p)
        {
            return SignedHIWORD((int)(long)p);
        }

        /// <summary>
        /// LONG 値を作成。
        /// </summary>
        public static int MAKELONG(int low, int high)
        {
            return ((high << 0x10) | (low & 0xffff));
        }

        /// <summary>
        /// LParam を作成。
        /// </summary>
        public static IntPtr MAKELPARAM(int low, int high)
        {
            return (IntPtr)((high << 0x10) | (low & 0xffff));
        }

        /// <summary>
        /// LParam を位置情報に変換。
        /// LParam に位置情報が送られるウインドウメッセージで使用します。
        /// </summary>
        public static Point LParamToPoint(IntPtr lParam)
        {
            return new Point(LOWORD(lParam), HIWORD(lParam));
        }

        /// <summary>
        /// LParam を符号付き位置情報に変換。
        /// LParam に位置情報が送られるウインドウメッセージで使用します。
        /// </summary>
        public static Point LParamToSignedPoint(IntPtr lParam)
        {
            return new Point(SignedLOWORD(lParam), SignedHIWORD(lParam));
        }

        /// <summary>
        /// 相対パスを取得します。
        /// </summary>
        public static string GetRelativePath(string basePath, string path)
        {
            Uri root = new Uri(basePath);
            Uri srcUri = new Uri(root, path);

            // 相対パスを取得します。
            string relativePathEscaped = root.MakeRelativeUri(srcUri).ToString();

            // Uri クラス が +  エンコードしてくれない文字があるので、自分で置換します。
            // relativePathEscaped = HttpUtility.UrlEncode( relativePathEscaped );
            relativePathEscaped = relativePathEscaped.Replace("+", "%2b");

            // エスケープされていない文字列に変換します
            string resultPath = System.Web.HttpUtility.UrlDecode(relativePathEscaped);
            // Uriクラスによって、置換された\マークをもとに戻します。
            resultPath = resultPath.Replace('/', '\\');


            return resultPath;
        }
    }
}
