﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Text;

namespace LECore.Structures
{
    /// <summary>
    /// Scene クラス
    /// 外部モジュール公開用インタフェース
    /// </summary>
    public interface IScene
    {
        ISubScene[] ISubSceneSet { get; }
        ISubScene CurrentISubScene { get; }

        ILEClipboard ILEClipboard { get; }

        /// <summary>
        /// ツールが利用できる、部品コントロール定義リストです。
        /// </summary>
        IEnumerable<IPartsControlSetting> PartsControlSettings { get; }

        /// <summary>
        /// 部品シーンです。
        /// </summary>
        IEnumerable<IPartsSubScene> PartsSubScenes { get; }

        /// <summary>
        /// 部品ファイルが格納されたフォルダです。
        /// </summary>
        string PartsRootPath { get; }

        event OnSceneModifyHandler OnSceneModify;

        /// <summary>
        /// 部品レイアウトが更新イベントです。
        /// </summary>
        event Action<string> OnPartsSubSceneModified;
    }
}
