﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Text;

namespace LECore.Structures
{
    using LECore.Structures.SerializableObject.Lyt;

    public interface ITexCoordHolder
    {
        int NumTexCoord { get; }
        TexCoord4 GetTexCoord4(int index);

        IMaterialTexMap[] IMaterialTexMapSet { get; }
    }

    public interface IShapeParam
    {
        ShapeType ShapeType { get; }
        uint CircleSlice { get; }
        uint SphereSlice { get; }
        uint SphereStack { get; }
        uint RoundRadius { get; }
        uint RoundSlice { get; }
    }

    /// <summary>
    /// Picture の外部モジュール公開用インタフェース
    /// </summary>
    public interface IPicture
        : IVertexColor4Holder, IPaneExParamater, ITexCoordHolder, IShapeParam
    {
        IMaterial IMaterial { get; }
        IProceduralShape IProceduralShape { get; }

        bool UseDetailedMaterial { get;}
    }
}
