﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace LECore.Structures
{
    /// <summary>
    /// 部品コントロール定義の公開インタフェースです。
    /// </summary>
    public interface IPartsControlSetting
    {
        /// <summary>
        /// 名前です。(TODO:実機ライブラリも関連するバリデート)
        /// </summary>
        string Name { get; }

        /// <summary>
        /// UI上の名前です。
        /// </summary>
        string UIName { get; }

        /// <summary>
        /// 説明です。
        /// </summary>
        string Description { get; }

        /// <summary>
        /// 定義ファイルです。
        /// </summary>
        string FilePath { get; }

        IEnumerable<PartsParamaterTemplate> AnimationNames { get; }
        IEnumerable<PartsParamaterTemplate> PaneNames { get; }
    }
}
