﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;

namespace LECore.Structures
{
    using LECoreInterface;
    using LECore.Structures.Core;
    using LECore.Structures.Nsrif.Attributes;

    /// <summary>
    /// キャプチャテクスチャの使われ方
    /// </summary>
    public enum CaptureTextureUsage
    {
        /// <summary>ユーザーが作成する通常のキャプチャテクスチャ</summary>
        Normal,
        /// <summary>マスクが自動的に作成するキャプチャテクスチャ</summary>
        Mask,
        /// <summary>ドロップシャドウ効果が自動的に作成するキャプチャテクスチャ</summary>
        DropShadow,
    }

    /// <summary>
    /// 外部モジュール公開インタフェース
    /// </summary>
    public interface ICaptureTexture
    {
        IPane OwnerPane { get; }
        string ReferencedPaneName { get; }
        bool FrameBufferCaptureEnabled { get; }
        bool CaptureOnlyFirstFrame { get; }
        FloatColor ClearColor { get; }
        float TextureScale { get; }
        CaptureTextureUsage Usage { get; }
        void RenderCaptureTexture(IRenderer renderer, ITextureImage bgImage);
    }
}
