﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Diagnostics;
using System.Drawing;

namespace LECore.Structures
{

    using Core;
    using LECoreInterface;
    using NWFont = NW4R.Font;

    /// <summary>
    /// Alignment ペインの情報
    /// 外部モジュール公開インタフェース
    /// </summary>
    public interface IAlignment
        : IDrawable, IPaneExParamater
    {
        /// <summary>
        /// 水平方向の並び方
        /// </summary>
        HorizontalLocation Horizontal { get; }

        /// <summary>
        /// 垂直方向の並び方
        /// </summary>
        VerticalLocation Vertical { get; }

        /// <summary>
        /// 水平マージン
        /// </summary>
        float DefaultHorizontalMargin { get; }

        /// <summary>
        /// 垂直マージン
        /// </summary>
        float DefaultVerticalMargin { get; }

        /// <summary>
        /// 水平方向の端ペインを拡張するかどうか
        /// </summary>
        bool IsExtendEdgeHorizontalEnabled { get; }

        /// <summary>
        /// 垂直方向の端ペインを拡張するかどうか
        /// </summary>
        bool IsExtendEdgeVerticalEnabled { get; }

        /// <summary>
        /// 水平方向の整列要素を利用するかどうか
        /// </summary>
        bool IsAlignmentHorizontalEnabled { get; }

        /// <summary>
        /// 垂直方向の整列要素を利用するかどうか
        /// </summary>
        bool IsAlignmentVerticalEnabled { get; }

    }

    public static class AlignmentHelper
    {
        public static bool HasAlignmentPaneTarget(this IAlignment src)
        {
            if(src == null || src.OwnerPane == null)
            {
                return false;
            }

            if(!src.OwnerPane.HasChildren)
            {
                return false;
            }

            return true;
        }
    }
}
