﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Diagnostics;
using System.Drawing;

namespace LECore.Structures
{
    using Core;


    /// <summary>
    /// Pictrue のアニメーションアトリビュート
    /// </summary>
    internal class VtxColor4Attribute
        : AnmAttribute
    {
        static readonly AnmAttrDescripter[] SubAttrDescs =
        {
            new  AnmAttrDescripter( AttributeType.ByteRGBA4, "vtx_col_LT", null, RGBAColor.White ),
            new  AnmAttrDescripter( AttributeType.ByteRGBA4, "vtx_col_RT", null, RGBAColor.White ),
            new  AnmAttrDescripter( AttributeType.ByteRGBA4, "vtx_col_LB", null, RGBAColor.White ),
            new  AnmAttrDescripter( AttributeType.ByteRGBA4, "vtx_col_RB", null, RGBAColor.White )
        };

        #region ------------- プロパティ -------------

        // 主にセーブロードで使用
        public AnmAttribute VtxCol_LTAnmAttr { get { return FindAttributeByIdx( 0 ); } }
        public AnmAttribute VtxCol_RTAnmAttr { get { return FindAttributeByIdx( 1 ); } }
        public AnmAttribute VtxCol_LBAnmAttr { get { return FindAttributeByIdx( 2 ); } }
        public AnmAttribute VtxCol_RBAnmAttr { get { return FindAttributeByIdx( 3 ); } }



        public RGBAColor GetContentsConerColorByIndex( int clockwiseIndexFromLT )
        {
            Debug.Assert( clockwiseIndexFromLT >= 0 && clockwiseIndexFromLT < 4 );
            int[] indexTable = { 0, 1, 3, 2 };
            return FindAttributeByIdx( indexTable[clockwiseIndexFromLT] ).GetAsRBGA();
        }

        public void SetContentsConerColorByIndex( int clockwiseIndexFromLT, RGBAColor color )
        {
            Debug.Assert( clockwiseIndexFromLT >= 0 && clockwiseIndexFromLT < 4 );
            int[] indexTable = { 0, 1, 3, 2 };
            FindAttributeByIdx( indexTable[clockwiseIndexFromLT] ).SetValue( color );
        }

        public RGBAColor VtxCol_LT
        {
            get { return VtxCol_LTAnmAttr.GetAsRBGA(); }
            set { VtxCol_LTAnmAttr.SetValue( value ); }
        }

        public RGBAColor VtxCol_RT
        {
            get { return VtxCol_RTAnmAttr.GetAsRBGA(); }
            set { VtxCol_RTAnmAttr.SetValue( value ); }
        }

        public RGBAColor VtxCol_LB
        {
            get { return VtxCol_LBAnmAttr.GetAsRBGA(); }
            set { VtxCol_LBAnmAttr.SetValue( value ); }
        }

        public RGBAColor VtxCol_RB
        {
            get { return VtxCol_RBAnmAttr.GetAsRBGA(); }
            set { VtxCol_RBAnmAttr.SetValue( value ); }
        }

        public Color[] ColorSet
        {
            get
            {
                return new Color[] {
                    VtxCol_LT.AsColor,
                    VtxCol_RT.AsColor,
                    VtxCol_RB.AsColor,
                    VtxCol_LB.AsColor };
            }
        }
        #endregion ------------- プロパティ -------------

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public VtxColor4Attribute( LEDataNode owner )
            : base(
            owner,
            SubAttrDescs,
            new AnmAttrDescripter( AttributeType.Combined, "vertex_colors", null, null ) )
        {

        }
    }
}
