﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;

namespace LECore.Util
{
    /// <summary>
    /// 範囲クラス。
    /// </summary>
    public class Range
    {
        // 最小値
        private int _min = 0;
        // 最大値
        private int _max = 0;

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public Range() {}

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public Range(int min, int max)
        {
            _min = min;
            _max = max;
        }

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public Range(Range range)
        {
            _min = range._min;
            _max = range._max;
        }

        /// <summary>
        /// 最小値。
        /// </summary>
        public int Min
        {
            get { return _min;  }
            set { _min = value; }
        }

        /// <summary>
        /// 最大値。
        /// </summary>
        public int Max
        {
            get { return _max;  }
            set { _max = value; }
        }

        /// <summary>
        /// 範囲内かどうか。
        /// </summary>
        public bool Contains(int val)
        {
            return _min <= val && val <= _max;
        }

        /// <summary>
        /// 範囲内に丸め込む。
        /// </summary>
        public void Truncate(ref int val)
        {
            if      (val < _min) { val = _min; }
            else if (val > _max) { val = _max; }
        }

        /// <summary>
        /// 範囲内に丸め込む。
        /// </summary>
        public int Truncate(int val)
        {
            if      (val < _min) { return _min; }
            else if (val > _max) { return _max; }
            return val;
        }
    }

    /// <summary>
    /// 小数値範囲クラス。
    /// </summary>
    public class RangeF
    {
        // 最小値
        private float _min = 0;
        // 最大値
        private float _max = 0;

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public RangeF() {}

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public RangeF(float min, float max)
        {
            _min = min;
            _max = max;
        }

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public RangeF(RangeF range)
        {
            _min = range._min;
            _max = range._max;
        }

        /// <summary>
        /// 最小値。
        /// </summary>
        public float Min
        {
            get { return _min;  }
            set { _min = value; }
        }

        /// <summary>
        /// 最大値。
        /// </summary>
        public float Max
        {
            get { return _max;  }
            set { _max = value; }
        }

        /// <summary>
        /// 範囲内かどうか。
        /// </summary>
        public bool Contains(float val)
        {
            return _min <= val && val <= _max;
        }

        /// <summary>
        /// 範囲内に丸め込む。
        /// </summary>
        public void Truncate(ref float val)
        {
            if      (val < _min) { val = _min; }
            else if (val > _max) { val = _max; }
        }

        /// <summary>
        /// 範囲内に丸め込む。
        /// </summary>
        public float Truncate(float val)
        {
            if      (val < _min) { return _min; }
            else if (val > _max) { return _max; }
            return val;
        }
    }
}
