﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Diagnostics;
using System.Threading.Tasks;

namespace LECore.Structures
{
    public static class ProcessUtil
    {
        // 入出力の設定をしつつプロセスを開始
        public static int? ProcessStart(string exe, string argument, DataReceivedEventHandler outputDataRecieved, DataReceivedEventHandler errorDataRecieved, out string error, int timeoutSec = 0, string workingDirectory = null)
        {
            error = "";
            var info = new ProcessStartInfo(exe, argument);
            info.CreateNoWindow = true;
            info.UseShellExecute = false;

            if (outputDataRecieved != null)
            {
                info.RedirectStandardOutput = true;
                info.StandardOutputEncoding = Encoding.Default;
            }

            if (errorDataRecieved != null)
            {
                info.RedirectStandardError = true;
                info.StandardErrorEncoding = Encoding.Default;
            }

            if (workingDirectory != null)
            {
                info.WorkingDirectory = workingDirectory;
            }

            Process process = null;

            try
            {
                {
                    process = new Process
                        {
                            StartInfo = info
                        };

                    if (outputDataRecieved != null)
                    {
                        process.OutputDataReceived += outputDataRecieved;
                    }
                    if (errorDataRecieved != null)
                    {
                        process.ErrorDataReceived += errorDataRecieved;
                    }

                    process.Start();
                    if (outputDataRecieved != null)
                    {
                        process.BeginOutputReadLine();
                    }
                    if (errorDataRecieved != null)
                    {
                        process.BeginErrorReadLine();
                    }
                    if (timeoutSec > 0)
                    {
                        process.WaitForExit(timeoutSec * 1000);
                        if (!process.HasExited)
                        {
                            try
                            {
                                process.Kill();
                            }
                            catch
                            {
                                ;
                            }
                            finally
                            {
                                if (errorDataRecieved != null)
                                {
                                    error = "Timeout:";
                                }
                            }
                        }
                    }
                    else
                    {
                        //process.WaitForExit(); だと Abort されない。詳しい理由は不明
                        while (!process.WaitForExit(10000)) { }
                    }
                }

                // エラーや例外が起きたときはログ出力しない
                return process.ExitCode;
            }
            catch(Exception e)
            {
                if (process != null)
                {
                    try
                    {
                        // プロセスが走っているかもしれないので止める
                        process.Kill();
                    }
                    catch
                    {
                        // 何もしない
                    }
                    finally
                    {
                        if (errorDataRecieved != null)
                        {
                            error = e.Message;
                        }
                    }
                }

                return null;
            }
        }
    }
}
