﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace LECore.Util
{
    static public class GenericUtil
    {
        /// <summary>
        /// 指定したノード以下の全ノードを並列化します。
        /// 深さ優先探索で親から順番に列挙します。
        /// <param name="root">基準となるノードを指定します。</param>
        /// <param name="getChildren">子ノードを取得する関数を指定します。</param>
        /// </summary>
        static public IEnumerable<T> GetNodeRecursively<T>(T root, Func<T, IEnumerable<T>> getChildren)
        {
            yield return root;
            var stack = new Stack<IEnumerator<T>>();
            stack.Push(getChildren(root).GetEnumerator());

            while(stack.Count > 0)
            {
                var enumerator = stack.Peek();
                if (enumerator.MoveNext())
                {
                    yield return enumerator.Current;
                    stack.Push(getChildren(enumerator.Current).GetEnumerator());
                }
                else
                {
                    stack.Pop();
                }
            }
        }
    }
}
