﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace LECore.Structures
{
    /// <summary>
    /// 部品パラメータのひな形です。
    /// </summary>
    public class PartsParamaterTemplate
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public PartsParamaterTemplate(string name, string description, bool isRequired)
        {
            this.Name = name;
            this.Description = description;
            this.IsRequired = isRequired;
        }

        //----------------------------------------------------------

        /// <summary>
        /// 名前です。(TODO:実機ライブラリも関連するバリデート)
        /// </summary>
        public string Name { get; private set; }

        /// <summary>
        /// 説明です。
        /// </summary>
        public string Description { get; private set; }

        /// <summary>
        /// 必須かどうかです。
        /// </summary>
        public bool IsRequired { get; private set; }
    }

    /// <summary>
    /// 部品設定のひな形情報です。
    /// </summary>
    internal class PartsControlSetting : IPartsControlSetting
    {
        private readonly PartsParamaterTemplate[] animationNames;
        private readonly PartsParamaterTemplate[] paneNames;

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public PartsControlSetting(
            string name, string uiName, string description, PartsParamaterTemplate[] animations, PartsParamaterTemplate[] panes)
        {
            this.Name = name;
            this.UIName = uiName;
            this.Description = description;

            this.animationNames = animations;
            this.paneNames = panes;
            this.FilePath = LECoreStringResMgr.Get("LECORE_DEFAULTCONTROL");
        }

        /// <summary>
        ///
        /// </summary>
        public void SetFilePath(string filePath)
        {
            this.FilePath = filePath;
        }

        /// <summary>
        /// 名前です。(TODO:実機ライブラリも関連するバリデート)
        /// </summary>
        public string Name { get; private set; }

        /// <summary>
        /// UI上の名前です。
        /// </summary>
        public string UIName { get; private set; }

        /// <summary>
        /// 説明です。
        /// </summary>
        public string Description { get; private set; }

        /// <summary>
        /// 定義ファイルです。
        /// </summary>
        public string FilePath { get; private set; }

        public IEnumerable<PartsParamaterTemplate> AnimationNames { get { return this.animationNames; } }
        public IEnumerable<PartsParamaterTemplate> PaneNames { get { return this.paneNames; } }
    }
}
