﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Diagnostics;

namespace LECore.Structures
{
    using Core;

    public interface IIndirectTexMtxSet
    {
        int NumTexIndirectMtx
        {
            get;
        }

        ITexMtx this[int index]
        {
            get;
        }
    }

    internal class TexIndirectMtxSet :
        LEDataNode,
        IIndirectTexMtxSet
    {
        const int NumIndirectTextureMtx = 3;
        const string TexIndirectMtxSetNodeName = "IndirectMtxSet";

        readonly TexMtx[] _texIndirectMtxSet = new TexMtx[NumIndirectTextureMtx];

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public TexIndirectMtxSet( LEDataNode ownerNode )
            : base( ownerNode, TexIndirectMtxSetNodeName )
        {
            for( int i = 0 ; i < _texIndirectMtxSet.Length ; i++ )
            {
                _texIndirectMtxSet[i] = new TexMtx( this, i );
            }
        }

        /// <summary>
        /// 値を設定します。
        /// </summary>
        public void Set( IIndirectTexMtxSet src )
        {
            for( int i = 0 ; i < _texIndirectMtxSet.Length ; i++ )
            {
                _texIndirectMtxSet[i].Set( src[i] );
            }
        }

        /// <summary>
        /// 行列を設定します。
        /// </summary>
        public void SetIndirectMtx( ITexMtx srcMtx, int idx )
        {
            TexMtx dstMtx = this[idx] as TexMtx;
            if( dstMtx != null )
            {
                dstMtx.Set( srcMtx );
            }
            else
            {
                Debug.Assert( false );
            }
        }

        #region IIndirectTexMtxSet

        public int NumTexIndirectMtx
        {
            get { return NumIndirectTextureMtx; }
        }

        public ITexMtx this[int index]
        {
            get
            {
                if( index < _texIndirectMtxSet.Length )
                {
                    return _texIndirectMtxSet[index];
                }
                return null;
            }
        }
        #endregion IIndirectTexMtxSet
    }

}
