﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;

namespace LECore.Structures
{
    using Core;
    using Nsrif.Attributes;

    #region TevSwapTables

    public interface ITevColorSwapTable
    {
        AttrSwapArg   R {get;}
        AttrSwapArg   G {get;}
        AttrSwapArg   B {get;}
        AttrSwapArg   A {get;}
    }

    /// <summary>
    /// スワップテーブル
    /// アニメーションしない。
    /// こちらを最終的に使用します。
    /// TevSwapTable は消去されます。
    /// </summary>
    internal class TevColorSwapTable :
        LEDataNode,
        ITevColorSwapTable
    {
        public const string TevColorSwapTableNodeName = "TevColorSwapTable";

        AttrSwapArg       _r =    AttrSwapArg.R;
        AttrSwapArg       _g =    AttrSwapArg.G;
        AttrSwapArg       _b =    AttrSwapArg.B;
        AttrSwapArg       _a =    AttrSwapArg.A;

        public AttrSwapArg   R {get{ return _r;} set{ _r = value;NotifyChange_();} }
        public AttrSwapArg   G {get{ return _g;} set{ _g = value;NotifyChange_();} }
        public AttrSwapArg   B {get{ return _b;} set{ _b = value;NotifyChange_();} }
        public AttrSwapArg   A {get{ return _a;} set{ _a = value;NotifyChange_();} }


        /// <summary>
        /// 変更の通知をします。
        /// </summary>
        void NotifyChange_()
        {
            NotifyModifyEvent( this, EventKind.Modify );
        }

        #region コンストラクタ
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public TevColorSwapTable( LEDataNode ownerNode )
            :base( ownerNode, TevColorSwapTableNodeName )
        {

        }
        #endregion コンストラクタ

        /// <summary>
        /// 値を設定します。
        /// </summary>>
        public void Set( ITevColorSwapTable src )
        {
            this.R = src.R;
            this.G = src.G;
            this.B = src.B;
            this.A = src.A;
        }
    }
    #endregion TevSwapTables
}
