﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Reflection;
using System.Diagnostics;

namespace LECore.Structures
{

    using Core;
    using LECore.Structures.Nsrif.Attributes;

    #region アニメーションアトリビュートとしての実装(未使用)
    #if false
    /// <summary>
    /// ColorAssignAttr
    /// 外部公開用インタフェース
    /// </summary>
    public interface IColorAssign
    {
        AttrColorAssignName     AttrColorAssignName{ get;}
        AttrColorAssignTarget   AttrColorAssignTarget{ get;}

        IAnmAttribute IAnmAttrName{ get;}
        IAnmAttribute IAnmAttrTarget{ get;}
    }

    /// <summary>
    /// マテリアル：アトリビュート：カラーアサイン
    /// </summary>
    internal class ColorAssignAttr :
        AnmAttribute,
        IColorAssign
    {
        static readonly AnmAttrDescripter[]  SubAttrDescs =
        {
            new  AnmAttrDescripter( AttributeType.Enum, "Name", null, AttrColorAssignName._Unknown ),
            new  AnmAttrDescripter( AttributeType.Enum, "Target", null, AttrColorAssignTarget._Unknown )
        };

        #region ------------ AnmAttrCreateFunc関連 ------------

        static public readonly AnmAttrCreateFunc  CreateFunc = new AnmAttrCreateFunc( CreateColorAssignAttr );

        static AnmAttribute CreateColorAssignAttr( AnmAttribute owner, AnmAttrDescripter attrDesc )
        {
            AnmAttrDescripter    selfAttrDesc =
                new AnmAttrDescripter( AttributeType.Combined, attrDesc._name, null, null );

            AnmAttribute anmAttr = new ColorAssignAttr( owner, selfAttrDesc );
            return anmAttr;
        }

        #endregion ------------ AnmAttrCreateFunc関連 ------------

        #region ------------ IColorAssignAttrメンバ ------------

        object GetSubAttrValue_( int attributeIdx )
        {
            object       val = null;

            AnmAttribute     anmAttr = this.FindAttributeByIdx( attributeIdx );
            Debug.Assert( anmAttr.Type == AttributeType.Enum );

            anmAttr.GetValue( out val );
            return val;
        }

        public AttrColorAssignName      AttrColorAssignName
        {
            get
            {
                AttrColorAssignName name = (AttrColorAssignName)GetSubAttrValue_( 0 );
                return name;
            }
        }

        public AttrColorAssignTarget    AttrColorAssignTarget
        {
            get
            {
                AttrColorAssignTarget target = (AttrColorAssignTarget)GetSubAttrValue_( 1 );
                // FIXME:GUIコードが AttrColorAssignTarget._Unknown
                // に対して、アサートに失敗するので。
                if( target == AttrColorAssignTarget._Unknown )
                {
                    target = AttrColorAssignTarget.AmbColor0Rgb;
                }
                return target;
            }
        }

        public IAnmAttribute IAnmAttrName  { get{ return FindSubAttributeByIdx( 0 );} }
        public IAnmAttribute IAnmAttrTarget{ get{ return FindSubAttributeByIdx( 1 );}}

        #endregion ------------ IColorAssignAttrメンバ ------------

        /// <summary>
        /// コンストラクタ(非公開)
        /// </summary>
        ColorAssignAttr( AnmAttribute owner, AnmAttrDescripter selfAttrDesc )
            : base( owner, SubAttrDescs, selfAttrDesc )
        {

        }
    }

    /// <summary>
    /// RevHWMaterialAttr
    /// 外部公開用インタフェース
    /// </summary>
    public interface IColorAssignSet
    {
        IColorAssign    DiffuseColorAssign{ get;}
        IColorAssign    AmbientColorAssign{ get;}
        IColorAssign    SpecularColorAssign{ get;}
        IColorAssign    AlphaColorAssign{ get;}
    }

    /// <summary>
    /// マテリアル：アトリビュート：カラーアサインセット
    /// </summary>
    internal class ColorAssignSetAttr :
        AnmAttribute,
        IColorAssignSet
    {
        static readonly AnmAttrDescripter[]  SubAttrDescs =
        {
            new  AnmAttrDescripter( AttributeType.Combined, "diffuse",  ColorAssignAttr.CreateFunc, null ),
            new  AnmAttrDescripter( AttributeType.Combined, "ambient",  ColorAssignAttr.CreateFunc, null ),
            new  AnmAttrDescripter( AttributeType.Combined, "specular", ColorAssignAttr.CreateFunc, null ),
            new  AnmAttrDescripter( AttributeType.Combined, "alpha",    ColorAssignAttr.CreateFunc, null )
        };



        #region ------------ AnmAttrCreateFunc関連 ------------

        static public readonly AnmAttrCreateFunc  CreateFunc =
            new AnmAttrCreateFunc( CreateColorAssignSetAttr );

        static AnmAttribute CreateColorAssignSetAttr( AnmAttribute owner, AnmAttrDescripter attrDesc )
        {
            AnmAttrDescripter    selfAttrDesc =
                new AnmAttrDescripter( AttributeType.Combined, attrDesc._name, null, null );
            return  new ColorAssignSetAttr( owner, selfAttrDesc );
        }

        #endregion ------------ AnmAttrCreateFunc関連 ------------

        #region ------------ IColorAssignSetメンバ ------------

        public IColorAssign DiffuseColorAssign { get{ return this.FindSubAttributeByIdx( 0 ) as IColorAssign;}}
        public IColorAssign AmbientColorAssign { get{ return this.FindSubAttributeByIdx( 1 ) as IColorAssign;}}
        public IColorAssign SpecularColorAssign{ get{ return this.FindSubAttributeByIdx( 2 ) as IColorAssign;}}
        public IColorAssign AlphaColorAssign   { get{ return this.FindSubAttributeByIdx( 3 ) as IColorAssign;}}

        #endregion ------------ IColorAssignSetメンバ ------------

        /// <summary>
        /// コンストラクタ(非公開)
        /// </summary>
        ColorAssignSetAttr( AnmAttribute owner, AnmAttrDescripter selfAttrDesc )
            : base( owner, SubAttrDescs, selfAttrDesc )
        {

        }
    }
    #endif
    #endregion アニメーションアトリビュートとしての実装(未使用)


    /// <summary>
    /// ColorAssignAttr
    /// 外部公開用インタフェース
    /// </summary>
    public interface IColorAssign
    {
        AttrColorAssignName     AttrColorAssignName{ get;}
        AttrColorAssignTarget   AttrColorAssignTarget{ get;}
    }

    /// <summary>
    /// マテリアル：アトリビュート：カラーアサイン
    /// </summary>
    internal class ColorAssignAttr :
        LEDataNode,
        IColorAssign
    {
        public const string ColorAssignAttrNodeName = "ColorAssign";
        readonly AttrColorAssignName    _attrColorAssignName     = AttrColorAssignName._Unknown;
        AttrColorAssignTarget           _attrColorAssignTarget   = AttrColorAssignTarget._Unknown;


        #region ------------ IColorAssignAttrメンバ ------------


        public AttrColorAssignName      AttrColorAssignName
        {
            get{ return _attrColorAssignName;}
        }

        public AttrColorAssignTarget    AttrColorAssignTarget
        {
            get{ return _attrColorAssignTarget;}
            set { _attrColorAssignTarget = value; NotifyModifyEvent(this, (int)SceneModifyEventArgs.Kind.PaneModify); }
        }


        #endregion ------------ IColorAssignAttrメンバ ------------

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public ColorAssignAttr( LEDataNode owner, AttrColorAssignName name )
            :base( owner, ColorAssignAttrNodeName )
        {
           _attrColorAssignName = name;
        }
    }

    /// <summary>
    /// RevHWMaterialAttr
    /// 外部公開用インタフェース
    ///
    /// 使用されそうなものだけ用意しています。
    /// </summary>
    public interface IColorAssignSet
    {
        IColorAssign    IColorAssignDiffuse { get;}
        IColorAssign    IColorAssignAlpha   { get;}

        AttrColorAssignTarget DiffuseAssignTarget  { get;}
        AttrColorAssignTarget AlphaAssignTarget    { get;}
    }

    /// <summary>
    /// マテリアル：アトリビュート：カラーアサインセット
    /// </summary>
    internal class ColorAssignSet :
        LEDataNode,
        IColorAssignSet
    {
        public const string ColorAssignSetNodeName = "ColorAssignSet";
        readonly ColorAssignAttr      _diffuse  = null;
        readonly ColorAssignAttr      _ambient  = null;
        readonly ColorAssignAttr      _specular = null;
        readonly ColorAssignAttr      _alpha    = null;

        #region ------------ IColorAssignSetメンバ ------------

        public IColorAssign IColorAssignDiffuse { get{ return _diffuse  as IColorAssign;}}
        public IColorAssign IColorAssignAlpha   { get{ return _alpha    as IColorAssign;}}

        // 実質的には、以下のパラメータのみが利用されています。
        public AttrColorAssignTarget DiffuseAssignTarget
        {
            get{ return _diffuse.AttrColorAssignTarget;}
            set
            {
                if( _diffuse.AttrColorAssignTarget != value )
                {
                    _diffuse.AttrColorAssignTarget = value;
                    NotifyModifyEvent(this, (int)SceneModifyEventArgs.Kind.PaneModify);
                }
            }
        }

        public AttrColorAssignTarget AlphaAssignTarget
        {
            get{ return _alpha.AttrColorAssignTarget;}
            set
            {
                if( _alpha.AttrColorAssignTarget != value )
                {
                    _alpha.AttrColorAssignTarget = value;
                    NotifyModifyEvent(this, (int)SceneModifyEventArgs.Kind.PaneModify);
                }
            }
        }

        #endregion ------------ IColorAssignSetメンバ ------------

        public ColorAssignAttr ColorAssignDiffuse {get{ return _diffuse; }}
        public ColorAssignAttr ColorAssignAlpha   {get{ return _alpha; }}



        /// <summary>
        /// コンストラクタ
        /// </summary>
        public ColorAssignSet( LEDataNode owner )
            :base( owner, ColorAssignSetNodeName )
        {
            _diffuse  = new ColorAssignAttr( this, AttrColorAssignName.Diffuse );
            _ambient  = new ColorAssignAttr( this, AttrColorAssignName.Ambient );
            _specular = new ColorAssignAttr( this, AttrColorAssignName.Specular );
            _alpha    = new ColorAssignAttr( this, AttrColorAssignName.Alpha );

            _diffuse.AttrColorAssignTarget = AttrColorAssignTarget.MatColor0Rgb;
            _alpha.AttrColorAssignTarget   = AttrColorAssignTarget.MatColor0A;
        }

        /// <summary>
        /// 値を設定します。
        /// </summary>
        public void Set( IColorAssignSet src )
        {
             DiffuseAssignTarget = src.DiffuseAssignTarget;
             AlphaAssignTarget   = src.AlphaAssignTarget;
        }
    }
}
