﻿using LECore.Structures.SerializableObject.Lyt;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace LECore.Structures
{
    /// <summary>
    /// レイアウトファイルのヘッダー
    /// </summary>
    internal class DocumentHeader : IDocumentHeader
    {
        public string _comment;

        #region IDocumentHeader
        public string Comment {
            get
            {
                return _comment;
            }
            set
            {
                if (_comment != value)
                {
                    _comment = value;
                    NotifyChageToScene();
                }
            }
        }
        #endregion

        #region UI では直接扱わないプロパティ

        public string Title { get; set; }
        public HeadCreate Create { get; set; }
        public HeadGenerator Generator { get; set; }

        #endregion

        /// <summary>
        /// 更新時に呼び出されるイベントです。
        /// </summary>
        public delegate void OnModifyHandler(DocumentHeader sender, SceneModifyEventArgs args);
        public event OnModifyHandler OnModify;

        void NotifyChageToScene()
        {
            if (OnModify != null)
            {
                SceneModifyEventArgs args = new SceneModifyEventArgs(SceneModifyEventArgs.Kind.SubScenePropertyModify, this);
                OnModify(this, args);
            }
        }
    }
}
