﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

//
// $Id: StringResMgr.cs,v 1.3 2007/01/31 06:34:35 kitani_toshikazu Exp $
// このコードは、3D エディタからコピーされたコードです。
//

using System;
using System.Diagnostics;
using System.Reflection;
using System.Resources;
using System.IO;
using System.Drawing;

namespace LECore
{
    /// <summary>
    /// 文字列リソースマネージャクラス。
    /// </summary>
    public sealed class LECoreStringResMgr
    {
        // リソースマネージャ
        private static ResourceManager _resMgr = null;

        /// <summary>
        /// 初期化処理。
        /// </summary>
        public static void Initialize()
        {
            // リソースマネージャ作成
            _resMgr = new ResourceManager("LECore.res.Strings", Assembly.GetExecutingAssembly());
        }

        /// <summary>
        /// 文字列取得。
        /// </summary>
        public static string Get(string id)
        {
            string result = _resMgr.GetString(id);
            Debug.Assert(result != null, string.Format("文字列リソース '{0}' が見つかりません。", id));
            return result;
        }

        /// <summary>
        /// 書式指定して文字列取得。
        /// </summary>
        public static string Get(string id, params object[] args)
        {
            string format = _resMgr.GetString(id);
            Debug.Assert(format != null, string.Format("文字列リソース '{0}' が見つかりません。", id));
            return string.Format(format, args);
        }

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        private LECoreStringResMgr() {}
    }

    /// <summary>
    /// ImageResMgr の概要の説明です。
    /// </summary>
    public sealed class LEImageResMgr
    {
        static LEImageResMgr() { }

        #region マニフェストリソース
        /// <summary>
        /// マニフェストリソースを取得。
        /// </summary>
        public static Stream GetManifestResourceStream( string name )
        {
            string resourceName = "LECore.res." + name;
            Stream resourceStream = Assembly.GetExecutingAssembly().GetManifestResourceStream( resourceName );
            Debug.Assert( resourceStream != null, string.Format( "マニフェストリソース '{0}' が見つかりません。", resourceName ) );
            return resourceStream;
        }

        /// <summary>
        /// マニフェストリソースビットマップを取得。
        /// </summary>
        public static Bitmap GetManifestResourceBitmap( string name )
        {
            return new Bitmap( GetManifestResourceStream( "bmp." + name ) );
        }

        /// <summary>
        /// マニフェストリソースビットマップを取得。
        /// </summary>
        public static Bitmap GetManifestResourcePng(string name)
        {
            return new Bitmap(GetManifestResourceStream("png." + name));
        }

        /// <summary>
        /// マニフェストリソースビットマップを取得。
        /// </summary>
        public static Icon GetManifestResourceIco(string name)
        {
            return new Icon(GetManifestResourceStream("ico." + name));
        }
        #endregion
    }
}
