﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml.Serialization;

namespace LECore.Save_Load
{
    /// <summary>
    /// シリアライザ生成処理が重いので、アプリケーションで生成するシリアライザを再利用するキャッシュ。
    /// </summary>
    public static class XmlSerializerCache
    {
        private static Dictionary<Type, XmlSerializer> _Serializers = new Dictionary<Type, XmlSerializer>();

        public static XmlSerializer GetXmlSerializer(Type type)
        {
            XmlSerializer result;
            if (!_Serializers.TryGetValue(type, out result))
            {
                result = new XmlSerializer(type);
                _Serializers.Add(type, result);
            }

            return result;
        }

        public static XmlSerializer GetXmlSerializer(Type type, Type[] extTypes)
        {
            XmlSerializer result;
            if (!_Serializers.TryGetValue(type, out result))
            {
                result = new XmlSerializer(type, extTypes);
                _Serializers.Add(type, result);
            }

            return result;
        }

        // 空白を保存したままデシリアライズする
        public static object Deserialize(XmlSerializer xmlSerializer, System.IO.Stream stream)
        {
            System.Xml.XmlDocument xmlDocument = new System.Xml.XmlDocument();
            xmlDocument.PreserveWhitespace = true; // 空白を保存する
            xmlDocument.Load(stream);

            System.Xml.XmlNodeReader xmlNodeReader = new System.Xml.XmlNodeReader(xmlDocument.DocumentElement);
            return xmlSerializer.Deserialize(xmlNodeReader);
        }
    }
}
