﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Text;
using System.Collections;
using System.Diagnostics;

namespace LECore.Save_Load
{
    using Structures;
    using Structures.Core;
    using Structures.SerializableObject.Lan;
    using System.Linq;
    using AppData = LECore.Structures;
    using FileFmt = LECore.Structures.SerializableObject.Lan;
    using static RlanHelper;

    class RlviConverter
    {
        #region ------------ Rlvi

        /// <summary>
        /// シリアライズデータ => アプリケーションデータ
        /// </summary>
        static public void LoadRlviToPane( object dstObject, FileFmt.AnimContent srcAnimContent, string tag)
        {
            Pane dstPane = dstObject as Pane;
            if( dstPane == null )
            {
                return;
            }

            if( dstPane.PaneName != srcAnimContent.name )
            {
                return;
            }

            foreach( FileFmt.AnimTarget animTarget in srcAnimContent.Items )
            {
                RlanHelper.SetBoolKeyFrame_( dstPane.PaneAttrRef.VisibleAttr, animTarget, tag );
            }
        }

        #endregion ------------- Rlvi

        #region ----------- Rlvi

        static public FileFmt.AnimContent[] SaveVisibilityAnim(AppData.IPane srcPane, string tag)
        {
            return ConvertToAnimContents<IPaneAttribute, AnimVisibilityTarget>(
                tag,
                ParamaterKind.Animation_Visivility,
                srcPane,
                x => new[] { new AnimContentSource<IPaneAttribute>(x.PaneName, x.IPaneAttribute) },
                x => new[] { new AnimTargetSource(x.VisibleIAttr, AnimTargetType.Visibility) }
                ).ToArray();
        }

        #endregion ------------- Rlvi
    }
}
