﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Diagnostics;

namespace LECore.Save_Load
{
    using Structures;
    using Structures.Core;
    using Structures.SerializableObject.Lan;
    using static RlanHelper;
    using AppData = LECore.Structures;
    using FileFmt = LECore.Structures.SerializableObject.Lan;

    public class RlpsConverter
    {
        public static void LoadRlpsToProceduralShape(object dstObject, FileFmt.AnimContent srcAnimContent, string tag)
        {
            Pane pane = dstObject as Pane;
            if (pane == null)
            {
                return;
            }
            if (pane.PaneName != srcAnimContent.name)
            {
                return;
            }
            if (pane.IPicture == null)
            {
                return;
            }
            ProceduralShape ownerProceduralShape = pane.IPicture.IProceduralShape as ProceduralShape;
            if (ownerProceduralShape == null)
            {
                return;
            }

            foreach (FileFmt.AnimTarget srcAnimTraget in srcAnimContent.Items)
            {
                AnmAttribute dstAttr = GetLoadTargetAttr_(srcAnimTraget.target, ownerProceduralShape);
                Debug.Assert(dstAttr != null);

                RlanHelper.SetHermiteKeyFrame_(dstAttr, srcAnimTraget, tag);
            }
        }

        static public FileFmt.AnimContent[] SaveProceduralShapeAnim(AppData.IPane srcPane, string tag)
        {
            return ConvertToAnimContents<IPane, AnimProceduralShapeTarget>(
                tag,
                ParamaterKind.Animation_ProceduralShape,
                srcPane,
                x => new[] { new AnimContentSource<IPane>(x.PaneName, x) },
                x =>
                {
                    if (x.IPicture == null)
                    {
                        return Enumerable.Empty<AnimTargetSource>();
                    }

                    var proceduralShape = x.IPicture.IProceduralShape as ProceduralShape;

                    return new[] { new AnimTargetSource(proceduralShape.ExpAttr, AnimTargetType.ProceduralShapeExp) }
                    .Concat(new[] { new AnimTargetSource(proceduralShape.RadiusAttr, AnimTargetType.ProceduralShapeRadius) })
                    .Concat(new[] { new AnimTargetSource(proceduralShape.InnerStrokeSizeAttr, AnimTargetType.ProceduralShapeInnerStrokeSize) })
                    .Concat(GetAnimTargetSourcesFromSubAttributes(proceduralShape.InnerStrokeColorAttr, new[] { AnimTargetType.ProceduralShapeInnerStrokeColor_r, AnimTargetType.ProceduralShapeInnerStrokeColor_g, AnimTargetType.ProceduralShapeInnerStrokeColor_b, AnimTargetType.ProceduralShapeInnerStrokeColor_a }))
                    .Concat(GetAnimTargetSourcesFromSubAttributes(proceduralShape.InnerShadowColorAttr, new[] { AnimTargetType.ProceduralShapeInnerShadowColor_r, AnimTargetType.ProceduralShapeInnerShadowColor_g, AnimTargetType.ProceduralShapeInnerShadowColor_b, AnimTargetType.ProceduralShapeInnerShadowColor_a }))
                    .Concat(new[] { new AnimTargetSource(proceduralShape.InnerShadowAngleAttr, AnimTargetType.ProceduralShapeInnerShadowAngle) })
                    .Concat(new[] { new AnimTargetSource(proceduralShape.InnerShadowDistanceAttr, AnimTargetType.ProceduralShapeInnerShadowDistance) })
                    .Concat(new[] { new AnimTargetSource(proceduralShape.InnerShadowSizeAttr, AnimTargetType.ProceduralShapeInnerShadowSize) })
                    .Concat(GetAnimTargetSourcesFromSubAttributes(proceduralShape.ColorOverlayColorAttr, new[] { AnimTargetType.ProceduralShapeColorOverlayColor_r, AnimTargetType.ProceduralShapeColorOverlayColor_g, AnimTargetType.ProceduralShapeColorOverlayColor_b, AnimTargetType.ProceduralShapeColorOverlayColor_a }))
                    .Concat(new[] { new AnimTargetSource(proceduralShape.GradationOverlayControlPointAttrArray[0], AnimTargetType.ProceduralShapeGradationOverlayControl0) })
                    .Concat(new[] { new AnimTargetSource(proceduralShape.GradationOverlayControlPointAttrArray[1], AnimTargetType.ProceduralShapeGradationOverlayControl1) })
                    .Concat(new[] { new AnimTargetSource(proceduralShape.GradationOverlayControlPointAttrArray[2], AnimTargetType.ProceduralShapeGradationOverlayControl2) })
                    .Concat(new[] { new AnimTargetSource(proceduralShape.GradationOverlayControlPointAttrArray[3], AnimTargetType.ProceduralShapeGradationOverlayControl3) })
                    .Concat(GetAnimTargetSourcesFromSubAttributes(proceduralShape.IGradationOverlayColorAttrArray[0], new[] { AnimTargetType.ProceduralShapeGradationOverlayColor0_r, AnimTargetType.ProceduralShapeGradationOverlayColor0_g, AnimTargetType.ProceduralShapeGradationOverlayColor0_b, AnimTargetType.ProceduralShapeGradationOverlayColor0_a }))
                    .Concat(GetAnimTargetSourcesFromSubAttributes(proceduralShape.IGradationOverlayColorAttrArray[1], new[] { AnimTargetType.ProceduralShapeGradationOverlayColor1_r, AnimTargetType.ProceduralShapeGradationOverlayColor1_g, AnimTargetType.ProceduralShapeGradationOverlayColor1_b, AnimTargetType.ProceduralShapeGradationOverlayColor1_a }))
                    .Concat(GetAnimTargetSourcesFromSubAttributes(proceduralShape.IGradationOverlayColorAttrArray[2], new[] { AnimTargetType.ProceduralShapeGradationOverlayColor2_r, AnimTargetType.ProceduralShapeGradationOverlayColor2_g, AnimTargetType.ProceduralShapeGradationOverlayColor2_b, AnimTargetType.ProceduralShapeGradationOverlayColor2_a }))
                    .Concat(GetAnimTargetSourcesFromSubAttributes(proceduralShape.IGradationOverlayColorAttrArray[3], new[] { AnimTargetType.ProceduralShapeGradationOverlayColor3_r, AnimTargetType.ProceduralShapeGradationOverlayColor3_g, AnimTargetType.ProceduralShapeGradationOverlayColor3_b, AnimTargetType.ProceduralShapeGradationOverlayColor3_a }))
                    .Concat(new[] { new AnimTargetSource(proceduralShape.IGradationOverlayAngleAttr, AnimTargetType.ProceduralShapeGradationOverlayAngle) })
                    .Concat(GetAnimTargetSourcesFromSubAttributes(proceduralShape.OuterShadowColorAttr, new[] { AnimTargetType.ProceduralShapeOuterShadowColor_r, AnimTargetType.ProceduralShapeOuterShadowColor_g, AnimTargetType.ProceduralShapeOuterShadowColor_b, AnimTargetType.ProceduralShapeOuterShadowColor_a }))
                    .Concat(new[] { new AnimTargetSource(proceduralShape.OuterShadowAngleAttr, AnimTargetType.ProceduralShapeOuterShadowAngle) })
                    .Concat(new[] { new AnimTargetSource(proceduralShape.OuterShadowDistanceAttr, AnimTargetType.ProceduralShapeOuterShadowDistance) })
                    .Concat(new[] { new AnimTargetSource(proceduralShape.OuterShadowSizeAttr, AnimTargetType.ProceduralShapeOuterShadowSize) });
                }).ToArray();
        }

        static AnmAttribute GetLoadTargetAttr_(FileFmt.AnimTargetType targetType, AppData.ProceduralShape ownerProceduralShape)
        {
            if (ownerProceduralShape == null)
            {
                return null;
            }

            switch (targetType)
            {
                case FileFmt.AnimTargetType.ProceduralShapeExp: return ownerProceduralShape.ExpAttr;
                case FileFmt.AnimTargetType.ProceduralShapeRadius: return ownerProceduralShape.RadiusAttr;

                case FileFmt.AnimTargetType.ProceduralShapeInnerStrokeSize: return ownerProceduralShape.InnerStrokeSizeAttr;
                case FileFmt.AnimTargetType.ProceduralShapeInnerStrokeColor_r: return ownerProceduralShape.InnerStrokeColorAttr.FindAttributeByIdx(0);
                case FileFmt.AnimTargetType.ProceduralShapeInnerStrokeColor_g: return ownerProceduralShape.InnerStrokeColorAttr.FindAttributeByIdx(1);
                case FileFmt.AnimTargetType.ProceduralShapeInnerStrokeColor_b: return ownerProceduralShape.InnerStrokeColorAttr.FindAttributeByIdx(2);
                case FileFmt.AnimTargetType.ProceduralShapeInnerStrokeColor_a: return ownerProceduralShape.InnerStrokeColorAttr.FindAttributeByIdx(3);

                case FileFmt.AnimTargetType.ProceduralShapeInnerShadowColor_r: return ownerProceduralShape.InnerShadowColorAttr.FindAttributeByIdx(0);
                case FileFmt.AnimTargetType.ProceduralShapeInnerShadowColor_g: return ownerProceduralShape.InnerShadowColorAttr.FindAttributeByIdx(1);
                case FileFmt.AnimTargetType.ProceduralShapeInnerShadowColor_b: return ownerProceduralShape.InnerShadowColorAttr.FindAttributeByIdx(2);
                case FileFmt.AnimTargetType.ProceduralShapeInnerShadowColor_a: return ownerProceduralShape.InnerShadowColorAttr.FindAttributeByIdx(3);

                case FileFmt.AnimTargetType.ProceduralShapeInnerShadowAngle: return ownerProceduralShape.InnerShadowAngleAttr;
                case FileFmt.AnimTargetType.ProceduralShapeInnerShadowDistance: return ownerProceduralShape.InnerShadowDistanceAttr;
                case FileFmt.AnimTargetType.ProceduralShapeInnerShadowSize: return ownerProceduralShape.InnerShadowSizeAttr;

                case FileFmt.AnimTargetType.ProceduralShapeColorOverlayColor_r: return ownerProceduralShape.ColorOverlayColorAttr.FindAttributeByIdx(0);
                case FileFmt.AnimTargetType.ProceduralShapeColorOverlayColor_g: return ownerProceduralShape.ColorOverlayColorAttr.FindAttributeByIdx(1);
                case FileFmt.AnimTargetType.ProceduralShapeColorOverlayColor_b: return ownerProceduralShape.ColorOverlayColorAttr.FindAttributeByIdx(2);
                case FileFmt.AnimTargetType.ProceduralShapeColorOverlayColor_a: return ownerProceduralShape.ColorOverlayColorAttr.FindAttributeByIdx(3);

                case FileFmt.AnimTargetType.ProceduralShapeGradationOverlayControl0: return ownerProceduralShape.GradationOverlayControlPointAttrArray[0];
                case FileFmt.AnimTargetType.ProceduralShapeGradationOverlayControl1: return ownerProceduralShape.GradationOverlayControlPointAttrArray[1];
                case FileFmt.AnimTargetType.ProceduralShapeGradationOverlayControl2: return ownerProceduralShape.GradationOverlayControlPointAttrArray[2];
                case FileFmt.AnimTargetType.ProceduralShapeGradationOverlayControl3: return ownerProceduralShape.GradationOverlayControlPointAttrArray[3];
                case FileFmt.AnimTargetType.ProceduralShapeGradationOverlayColor0_r: return ownerProceduralShape.GradationOverlayColorAttrArray[0].FindAttributeByIdx(0);
                case FileFmt.AnimTargetType.ProceduralShapeGradationOverlayColor0_g: return ownerProceduralShape.GradationOverlayColorAttrArray[0].FindAttributeByIdx(1);
                case FileFmt.AnimTargetType.ProceduralShapeGradationOverlayColor0_b: return ownerProceduralShape.GradationOverlayColorAttrArray[0].FindAttributeByIdx(2);
                case FileFmt.AnimTargetType.ProceduralShapeGradationOverlayColor0_a: return ownerProceduralShape.GradationOverlayColorAttrArray[0].FindAttributeByIdx(3);
                case FileFmt.AnimTargetType.ProceduralShapeGradationOverlayColor1_r: return ownerProceduralShape.GradationOverlayColorAttrArray[1].FindAttributeByIdx(0);
                case FileFmt.AnimTargetType.ProceduralShapeGradationOverlayColor1_g: return ownerProceduralShape.GradationOverlayColorAttrArray[1].FindAttributeByIdx(1);
                case FileFmt.AnimTargetType.ProceduralShapeGradationOverlayColor1_b: return ownerProceduralShape.GradationOverlayColorAttrArray[1].FindAttributeByIdx(2);
                case FileFmt.AnimTargetType.ProceduralShapeGradationOverlayColor1_a: return ownerProceduralShape.GradationOverlayColorAttrArray[1].FindAttributeByIdx(3);
                case FileFmt.AnimTargetType.ProceduralShapeGradationOverlayColor2_r: return ownerProceduralShape.GradationOverlayColorAttrArray[2].FindAttributeByIdx(0);
                case FileFmt.AnimTargetType.ProceduralShapeGradationOverlayColor2_g: return ownerProceduralShape.GradationOverlayColorAttrArray[2].FindAttributeByIdx(1);
                case FileFmt.AnimTargetType.ProceduralShapeGradationOverlayColor2_b: return ownerProceduralShape.GradationOverlayColorAttrArray[2].FindAttributeByIdx(2);
                case FileFmt.AnimTargetType.ProceduralShapeGradationOverlayColor2_a: return ownerProceduralShape.GradationOverlayColorAttrArray[2].FindAttributeByIdx(3);
                case FileFmt.AnimTargetType.ProceduralShapeGradationOverlayColor3_r: return ownerProceduralShape.GradationOverlayColorAttrArray[3].FindAttributeByIdx(0);
                case FileFmt.AnimTargetType.ProceduralShapeGradationOverlayColor3_g: return ownerProceduralShape.GradationOverlayColorAttrArray[3].FindAttributeByIdx(1);
                case FileFmt.AnimTargetType.ProceduralShapeGradationOverlayColor3_b: return ownerProceduralShape.GradationOverlayColorAttrArray[3].FindAttributeByIdx(2);
                case FileFmt.AnimTargetType.ProceduralShapeGradationOverlayColor3_a: return ownerProceduralShape.GradationOverlayColorAttrArray[3].FindAttributeByIdx(3);
                case FileFmt.AnimTargetType.ProceduralShapeGradationOverlayAngle: return ownerProceduralShape.GradationOverlayAngleAttr;

                case FileFmt.AnimTargetType.ProceduralShapeOuterShadowColor_r: return ownerProceduralShape.OuterShadowColorAttr.FindAttributeByIdx(0);
                case FileFmt.AnimTargetType.ProceduralShapeOuterShadowColor_g: return ownerProceduralShape.OuterShadowColorAttr.FindAttributeByIdx(1);
                case FileFmt.AnimTargetType.ProceduralShapeOuterShadowColor_b: return ownerProceduralShape.OuterShadowColorAttr.FindAttributeByIdx(2);
                case FileFmt.AnimTargetType.ProceduralShapeOuterShadowColor_a: return ownerProceduralShape.OuterShadowColorAttr.FindAttributeByIdx(3);

                case FileFmt.AnimTargetType.ProceduralShapeOuterShadowAngle: return ownerProceduralShape.OuterShadowAngleAttr;
                case FileFmt.AnimTargetType.ProceduralShapeOuterShadowDistance: return ownerProceduralShape.OuterShadowDistanceAttr;
                case FileFmt.AnimTargetType.ProceduralShapeOuterShadowSize: return ownerProceduralShape.OuterShadowSizeAttr;

                default: Debug.Assert(false); return null;
            }
        }
    }
}
