﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Diagnostics;

namespace LECore.Save_Load
{
    using Structures;
    using Structures.Core;
    using Structures.SerializableObject.Lan;
    using static RlanHelper;
    using AppData = LECore.Structures;
    using FileFmt = LECore.Structures.SerializableObject.Lan;

    public class RlmaConverter
    {
        public static void LoadRlmaToMask(object dstObject, FileFmt.AnimContent srcAnimContent, string tag)
        {
            Pane pane = dstObject as Pane;
            if (pane == null)
            {
                return;
            }
            if (pane.PaneName != srcAnimContent.name)
            {
                return;
            }
            Mask ownerMask = pane.IMask as Mask;
            if (ownerMask == null)
            {
                return;
            }

            foreach (FileFmt.AnimTarget srcAnimTraget in srcAnimContent.Items)
            {
                AnmAttribute dstAttr = GetLoadTargetAttr_(srcAnimTraget.target, ownerMask);
                Debug.Assert(dstAttr != null);

                RlanHelper.SetHermiteKeyFrame_(dstAttr, srcAnimTraget, tag);
            }
        }

        static public FileFmt.AnimContent[] SaveMaskAnim(AppData.IPane srcPane, string tag)
        {
            return ConvertToAnimContents<IPane, AnimMaskTarget>(
                tag,
                ParamaterKind.Animation_TextureSRT,
                srcPane,
                x => new[] { new AnimContentSource<IPane>(x.PaneName, x) },
                x =>
                {
                    var mask = x.IMask as Mask;
                    if (mask != null)
                    {
                        return GetAnimTargetSourcesFromSubAttributes(mask.MtxTransAttr, new[] { AnimTargetType.MaskMtxTransX, AnimTargetType.MaskMtxTransY })
                            .Concat(GetAnimTargetSourcesFromSubAttributes(mask.MtxScaleAttr, new[] { AnimTargetType.MaskMtxScaleX, AnimTargetType.MaskMtxScaleY }))
                            .Concat(new[] { new AnimTargetSource(mask.MtxRotateAttr, AnimTargetType.MaskMtxRotate) });
                    }
                    return Enumerable.Empty<AnimTargetSource>();
                }).ToArray();
        }

        static AnmAttribute GetLoadTargetAttr_(FileFmt.AnimTargetType targetType, AppData.Mask ownerMask)
        {
            if (ownerMask == null)
            {
                return null;
            }

            switch (targetType)
            {
                case FileFmt.AnimTargetType.MaskMtxTransX: return ownerMask.MtxTransAttr.FindAttributeByIdx(0);
                case FileFmt.AnimTargetType.MaskMtxTransY: return ownerMask.MtxTransAttr.FindAttributeByIdx(1);
                case FileFmt.AnimTargetType.MaskMtxScaleX: return ownerMask.MtxScaleAttr.FindAttributeByIdx(0);
                case FileFmt.AnimTargetType.MaskMtxScaleY: return ownerMask.MtxScaleAttr.FindAttributeByIdx(1);
                case FileFmt.AnimTargetType.MaskMtxRotate: return ownerMask.MtxRotateAttr;
                default: Debug.Assert(false); return null;
            }
        }
    }
}
