﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Text;
using System.Linq;

using System.Collections;
using System.Diagnostics;

namespace LECore.Save_Load
{
    using Structures;
    using Structures.Core;
    using Structures.SerializableObject.Lan;
    using static RlanHelper;
    using AppData = LECore.Structures;
    using FileFmt = LECore.Structures.SerializableObject.Lan;

    class RlfsConverter
    {
        #region ------------ Rlac 書き出し

        /// <summary>
        /// Rlfs の エクスポート
        /// </summary>
        static public FileFmt.AnimContent[] SaveAnimation(AppData.IPane srcPane, string tag)
        {
            return ConvertToAnimContents<TextBox, FileFmt.AnimFontShadowTarget>(
                tag,
                ParamaterKind.Animation_MaterialColors,
                srcPane,
                x => x.ITextBox is TextBox ? new[] { new AnimContentSource<TextBox>(x.PaneName, (TextBox)x.ITextBox) }: Enumerable.Empty<AnimContentSource<TextBox>>(),
                x => GetAnimTargetSourcesFromSubAttributes(x.TextBoxAnmAttr.ShadowBlackColorAttr, new [] { AnimTargetType.FontShadowBlackColor_r, AnimTargetType.FontShadowBlackColor_g, AnimTargetType.FontShadowBlackColor_b })
                    .Concat(GetAnimTargetSourcesFromSubAttributes(x.TextBoxAnmAttr.ShadowWhiteColorAttr, new [] { AnimTargetType.FontShadowWhiteColor_r, AnimTargetType.FontShadowWhiteColor_g, AnimTargetType.FontShadowWhiteColor_b, AnimTargetType.FontShadowWhiteColor_a }))
                ).ToArray();
        }
        #endregion -------------- Rlac


        #region ----------- Rlac 読み込み

        /// <summary>
        /// マテリアルカラー（ハード固有表現）
        /// </summary>
        static public void Load(object dstObject, FileFmt.AnimContent animContent, string tag)
        {
            Pane pane = dstObject as Pane;
            if (pane == null)
            {
                return;
            }

            var ownerTextBox = pane.ITextBox as TextBox;
            if (ownerTextBox == null)
            {
                return;
            }

            if (pane.PaneName != animContent.name)
            {
                return;
            }

            foreach (FileFmt.AnimTarget animTarget in animContent.Items)
            {
                AnmAttribute targetAttr = GetLoadTargetAttr_(animTarget.target, ownerTextBox);
                if (targetAttr != null)
                {
                    RlanHelper.SetHermiteKeyFrame_(targetAttr, animTarget, tag);
                }
            }
        }

        /// <summary>
        /// 対象アトリビュートの発見
        /// </summary>
        static AnmAttribute GetLoadTargetAttr_(AnimTargetType targetType, TextBox ownerTextBox)
        {
            if (ownerTextBox == null)
            {
                return null;
            }

            switch (targetType)
            {
                case FileFmt.AnimTargetType.FontShadowBlackColor_r: return ownerTextBox.TextBoxAnmAttr.ShadowBlackColorAttr.FindAttributeByIdx(0);
                case FileFmt.AnimTargetType.FontShadowBlackColor_g: return ownerTextBox.TextBoxAnmAttr.ShadowBlackColorAttr.FindAttributeByIdx(1);
                case FileFmt.AnimTargetType.FontShadowBlackColor_b: return ownerTextBox.TextBoxAnmAttr.ShadowBlackColorAttr.FindAttributeByIdx(2);

                case FileFmt.AnimTargetType.FontShadowWhiteColor_r: return ownerTextBox.TextBoxAnmAttr.ShadowWhiteColorAttr.FindAttributeByIdx(0);
                case FileFmt.AnimTargetType.FontShadowWhiteColor_g: return ownerTextBox.TextBoxAnmAttr.ShadowWhiteColorAttr.FindAttributeByIdx(1);
                case FileFmt.AnimTargetType.FontShadowWhiteColor_b: return ownerTextBox.TextBoxAnmAttr.ShadowWhiteColorAttr.FindAttributeByIdx(2);
                case FileFmt.AnimTargetType.FontShadowWhiteColor_a: return ownerTextBox.TextBoxAnmAttr.ShadowWhiteColorAttr.FindAttributeByIdx(3);
                default: return null;
            }
        }

        #endregion --------- Rlac
    }
}
