﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Diagnostics;

namespace LECore.Save_Load
{
    using Structures;
    using Structures.Core;
    using Structures.SerializableObject.Lan;
    using static RlanHelper;
    using AppData = LECore.Structures;
    using FileFmt = LECore.Structures.SerializableObject.Lan;

    public class RldsConverter
    {
        public static void LoadRldsToDropShadow(object dstObject, FileFmt.AnimContent srcAnimContent, string tag)
        {
            Pane pane = dstObject as Pane;
            if (pane == null)
            {
                return;
            }
            if (pane.PaneName != srcAnimContent.name)
            {
                return;
            }
            DropShadow ownerDropShadow = pane.IDropShadow as DropShadow;
            if (ownerDropShadow == null)
            {
                return;
            }

            foreach (FileFmt.AnimTarget srcAnimTraget in srcAnimContent.Items)
            {
                AnmAttribute dstAttr = GetLoadTargetAttr_(srcAnimTraget.target, ownerDropShadow);
                Debug.Assert(dstAttr != null);

                RlanHelper.SetHermiteKeyFrame_(dstAttr, srcAnimTraget, tag);
            }
        }

        static public FileFmt.AnimContent[] SaveDropShadowAnim(AppData.IPane srcPane, string tag)
        {
            return ConvertToAnimContents<IPane, AnimDropShadowTarget>(
                tag,
                ParamaterKind.Animation_DropShadow,
                srcPane,
                x => new[] { new AnimContentSource<IPane>(x.PaneName, x) },
                x =>
                {
                    var dropShadow = x.IDropShadow as DropShadow;
                    return new[] { new AnimTargetSource(dropShadow.StrokeSizeAttr, AnimTargetType.StrokeSize) }
                    .Concat(GetAnimTargetSourcesFromSubAttributes(dropShadow.StrokeColorAttr, new[] { AnimTargetType.StrokeColor_r, AnimTargetType.StrokeColor_g, AnimTargetType.StrokeColor_b, AnimTargetType.StrokeColor_a }))
                    .Concat(GetAnimTargetSourcesFromSubAttributes(dropShadow.OuterGlowColorAttr, new[] { AnimTargetType.OuterGlowColor_r, AnimTargetType.OuterGlowColor_g, AnimTargetType.OuterGlowColor_b, AnimTargetType.OuterGlowColor_a }))
                    .Concat(new[] { new AnimTargetSource(dropShadow.OuterGlowSpreadAttr, AnimTargetType.OuterGlowSpread) })
                    .Concat(new[] { new AnimTargetSource(dropShadow.OuterGlowSizeAttr, AnimTargetType.OuterGlowSize) })
                    .Concat(GetAnimTargetSourcesFromSubAttributes(dropShadow.DropShadowColorAttr, new[] { AnimTargetType.DropShadowColor_r, AnimTargetType.DropShadowColor_g, AnimTargetType.DropShadowColor_b, AnimTargetType.DropShadowColor_a }))
                    .Concat(new[] { new AnimTargetSource(dropShadow.DropShadowAngleAttr, AnimTargetType.DropShadowAngle) })
                    .Concat(new[] { new AnimTargetSource(dropShadow.DropShadowDistanceAttr, AnimTargetType.DropShadowDistance) })
                    .Concat(new[] { new AnimTargetSource(dropShadow.DropShadowSpreadAttr, AnimTargetType.DropShadowSpread) })
                    .Concat(new[] { new AnimTargetSource(dropShadow.DropShadowSizeAttr, AnimTargetType.DropShadowSize) });
                }).ToArray();
        }

        static AnmAttribute GetLoadTargetAttr_(FileFmt.AnimTargetType targetType, AppData.DropShadow ownerDropShadow)
        {
            if (ownerDropShadow == null)
            {
                return null;
            }

            switch (targetType)
            {
                case FileFmt.AnimTargetType.StrokeSize: return ownerDropShadow.StrokeSizeAttr;
                case FileFmt.AnimTargetType.StrokeColor_r: return ownerDropShadow.StrokeColorAttr.FindAttributeByIdx(0);
                case FileFmt.AnimTargetType.StrokeColor_g: return ownerDropShadow.StrokeColorAttr.FindAttributeByIdx(1);
                case FileFmt.AnimTargetType.StrokeColor_b: return ownerDropShadow.StrokeColorAttr.FindAttributeByIdx(2);
                case FileFmt.AnimTargetType.StrokeColor_a: return ownerDropShadow.StrokeColorAttr.FindAttributeByIdx(3);
                case FileFmt.AnimTargetType.OuterGlowColor_r: return ownerDropShadow.OuterGlowColorAttr.FindAttributeByIdx(0);
                case FileFmt.AnimTargetType.OuterGlowColor_g: return ownerDropShadow.OuterGlowColorAttr.FindAttributeByIdx(1);
                case FileFmt.AnimTargetType.OuterGlowColor_b: return ownerDropShadow.OuterGlowColorAttr.FindAttributeByIdx(2);
                case FileFmt.AnimTargetType.OuterGlowColor_a: return ownerDropShadow.OuterGlowColorAttr.FindAttributeByIdx(3);
                case FileFmt.AnimTargetType.OuterGlowSpread: return ownerDropShadow.OuterGlowSpreadAttr;
                case FileFmt.AnimTargetType.OuterGlowSize: return ownerDropShadow.OuterGlowSizeAttr;
                case FileFmt.AnimTargetType.DropShadowColor_r: return ownerDropShadow.DropShadowColorAttr.FindAttributeByIdx(0);
                case FileFmt.AnimTargetType.DropShadowColor_g: return ownerDropShadow.DropShadowColorAttr.FindAttributeByIdx(1);
                case FileFmt.AnimTargetType.DropShadowColor_b: return ownerDropShadow.DropShadowColorAttr.FindAttributeByIdx(2);
                case FileFmt.AnimTargetType.DropShadowColor_a: return ownerDropShadow.DropShadowColorAttr.FindAttributeByIdx(3);
                case FileFmt.AnimTargetType.DropShadowAngle: return ownerDropShadow.DropShadowAngleAttr;
                case FileFmt.AnimTargetType.DropShadowDistance: return ownerDropShadow.DropShadowDistanceAttr;
                case FileFmt.AnimTargetType.DropShadowSpread: return ownerDropShadow.DropShadowSpreadAttr;
                case FileFmt.AnimTargetType.DropShadowSize: return ownerDropShadow.DropShadowSizeAttr;
                default: Debug.Assert(false); return null;
            }
        }
    }
}
