﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Text;
using System.Linq;

using System.Collections;
using System.Diagnostics;

namespace LECore.Save_Load
{
    using Structures;
    using Structures.Core;
    using Structures.SerializableObject.Lan;
    using static RlanHelper;
    using AppData = LECore.Structures;
    using FileFmt = LECore.Structures.SerializableObject.Lan;

    class RlacConverter
    {
        #region ------------ Rlac 書き出し
        /// <summary>
        /// Rlac の エクスポート
        /// </summary>
        public static FileFmt.AnimContent[] SaveAnimation(AppData.IPane srcPane, string tag)
        {
            return ConvertToAnimContents<IRevHWMaterial, AnimAlphaTestTarget>(
                tag,
                ParamaterKind.Animation_AlphaTest,
                srcPane,
                x => (x.IPaneExParamater as IRevHWMaterialHolder)?.IRevHWMaterial?.Select(y => new AnimContentSource<IRevHWMaterial>(y.MaterialName, y)) ?? Enumerable.Empty<AnimContentSource<IRevHWMaterial>>(),
                x => new[] { new AnimTargetSource(x.IPEData.ACompare.RefAnmAttr, FileFmt.AnimTargetType.AlphaTest) }
                ).ToArray();
        }
        #endregion -------------- Rlac


        #region ----------- Rlac 読み込み

        /// <summary>
        /// 読み込み
        /// </summary>
        static public void LoadRlmcToMaterial(object dstObject, FileFmt.AnimContent animContent, string tag)
        {
            Pane pane = dstObject as Pane;
            if (pane == null)
            {
                return;
            }

            RevHWMaterial dstMaterial = pane.EnumrateDetailMaterial().FirstOrDefault(
                (mat) => mat.MaterialName == animContent.name) as RevHWMaterial;
            if(dstMaterial == null)
            {
                return;
            }

            foreach (FileFmt.AnimTarget animTarget in animContent.Items)
            {
                switch(animTarget.target)
                {
                    case AnimTargetType.AlphaTest:
                        AnmAttribute targetAttr = dstMaterial.PEData.ACompare.RefAnmAttr as AnmAttribute;
                        RlanHelper.SetHermiteKeyFrame_(targetAttr, animTarget, tag);
                        break;
                }
            }
        }

        #endregion --------- Rlac
    }
}
