﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Text;
using System.Collections;
using System.Diagnostics;

namespace LECore.Save_Load
{
    using Structures;
    using Structures.Core;
    using Structures.SerializableObject.Lct;

    using AppData = LECore.Structures;
    using FileFmt = LECore.Structures.SerializableObject.Lct;

    class ClctConverter
    {
        readonly LEMsgReporter _msgReporter = null;

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public ClctConverter(LEMsgReporter msgReporter)
        {
            _msgReporter = msgReporter;
        }

        #region ------------ Cclt

        /// <summary>
        /// シリアライズデータ => アプリケーションデータ
        /// </summary>
        public void LoadClctToPane(object dstObject, FileFmt.Document srcDocument, string srcFilePath)
        {
            Scene dstPane = dstObject as Scene;
            if (dstPane == null)
            {
                return;
            }

            if (srcDocument == null || srcDocument.body == null || srcDocument.body.lct == null)
            {
                return;
            }

            List<IPartsControlSetting> controlSettings = new List<IPartsControlSetting>();
            foreach (var controlForm in srcDocument.body.lct)
            {
                IPartsControlSetting parts = Scene.Instance.FindPartsControlSetting(controlForm.name);
                if (parts != null)
                {
                    _msgReporter.ReportError(
                        LECoreStringResMgr.Get("LECORE_CATEGORY_PARTSTEMPLATELOADING"),
                        LECoreStringResMgr.Get("LECORE_ERROR_INVALIDSAMENAME", parts.Name));
                    continue;
                }

                List<PartsParamaterTemplate> paramAnims = new List<PartsParamaterTemplate>();
                if (controlForm.parameterAnimation != null)
                {
                    foreach (var srcAnim in controlForm.parameterAnimation)
                    {
                        paramAnims.Add(new PartsParamaterTemplate(
                            srcAnim.name,
                            srcAnim.description,
                            srcAnim.isRequired));
                    }
                }

                List<PartsParamaterTemplate> paramPanes = new List<PartsParamaterTemplate>();
                if (controlForm.parameterPane != null)
                {
                    foreach (var srcPane in controlForm.parameterPane)
                    {
                        paramPanes.Add(new PartsParamaterTemplate(
                            srcPane.name,
                            SerializableConverterUtil.ReplaceLineFeedCode(srcPane.description),
                            srcPane.isRequired));
                    }
                }

                PartsControlSetting newControl = new PartsControlSetting(
                                    controlForm.name,
                                    string.IsNullOrEmpty(controlForm.uiName) ? controlForm.name : controlForm.uiName,
                                    SerializableConverterUtil.ReplaceLineFeedCode(controlForm.description),
                                    paramAnims.ToArray(),
                                    paramPanes.ToArray());
                newControl.SetFilePath(srcFilePath);

                controlSettings.Add(newControl);
            }

            Scene.Instance.RegisterPartsControlSetting(controlSettings);
        }

        #endregion ------------- Cclt
    }
}
