﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;

namespace LECore.Save_Load
{
    using Structures;

    [Flags]
    public enum IImporterOption
    {
        None = 0x0,
        DoNotReportFailure = 0x1,
        IsAdditionalImport = 0x2,// （新規シーンではなく）既存のシーンに追加で読み込む処理を表します。
    };

    /// <summary>
    /// シーンにデータをインポートするモジュールが
    /// 実装するインタフェースです。
    ///
    /// ImporterExcutor クラス によって 実際のインポート処理を実行します。
    /// </summary>
    public interface IImporter : IFileInfoHolder
    {
        void SetOptionFlag( IImporterOption option );
        /// <summary>
        /// セーブ前のクリーンアップ処理
        /// </summary>
        /// <param name="targetScene"></param>
        void BeforeLoadingCleanup( ISubScene targetScene );

        /// <summary>
        /// ファイルを読み込みます。
        /// ファイル読み込みに成功した場合は true が返ります。
        /// </summary>
        bool DoLoad( string inPath, ISubScene targetScene );

        /// <summary>
        /// ログ出力などを受け取るクラスを設定します。
        /// </summary>
        LEMsgReporter    MsgReporter { set; }
    }
}
