﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Diagnostics;
using System.Collections.Generic;
using System.Text;

namespace LECore.Save_Load
{
    public interface IFileInfoHolder
    {
        /// <summary>
        /// 出力ファイルの拡張子を取得します(短縮)。
        /// </summary>
        string[] GetFileExtensionShort();

        /// <summary>
        /// 出力ファイルの拡張子を取得します(長い)。
        /// </summary>
        string[] GetFileExtensionLong();

    }

    public class SaveLoadHelper
    {
        static public string GetFliterString( IFileInfoHolder fileInfo )
        {
            string resultFilter = string.Empty;

            string[] extLongSet = fileInfo.GetFileExtensionLong();
            string[] extShortSet = fileInfo.GetFileExtensionShort();
            Debug.Assert( extLongSet.Length == extShortSet.Length );

            for( int i = 0 ; i < extLongSet.Length ; i++ )
            {
                string filter = string.Format( "{0} (*.{1})|*.{1}|", extLongSet[i], extShortSet[i] );
                resultFilter += filter;
            }
            // all 全て   を最後に追加
            resultFilter += "all (*.*)|*.*";


            return resultFilter;
        }
    }
}
