﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;

namespace LECore.Save_Load
{
    using LECore.Structures;

    /// <summary>
    /// 入出力ファイル種類
    /// </summary>
    public enum ImportExportFileKind
    {
        All,
        Rlan,
        Rlyt,
        Rlpa,
        Rlvi,
        Rltp,
        Rlvc,
        Rlmc,
        Rlts,
        Clct,
    }

    public class ExportOption
    {
        /// <summary>
        /// プレビューで異常終了しないように
        /// フォントが発見できなかったテキストボックスをNullに変換します。
        /// </summary>
        public bool ConvertInvalidTextboxToNull { get; set; }

        /// <summary>
        /// プレビュー時にInfinityCurve を焼き付けるか
        /// </summary>
        public bool BakeAnimationInfinityCurve { get; set; }

        /// <summary>
        /// 選択フレームの範囲を再生範囲とするか
        /// </summary>
        public bool UseTargetFrameSectionRangeAsPlayRange { get; set; }

        /// <summary>
        /// ビューア転送時に再生範囲を自動的に調整するか
        /// </summary>
        public bool AutoAdjustPlayRange { get; set; }

        /// <summary>
        /// レイアウトの値を評価するフレーム
        /// </summary>
        public int Frame { get; set; } = 0;

        /// <summary>
        /// Frame を使用して値の評価を行いシリアライズ対象のデータに代入する
        /// </summary>
        public AfterExportOption AfterExport { get; set; } = AfterExportOption.None;

        public enum AfterExportOption {
            None,
            RetriveValues,
            ResetFrame,
        };

        /// <summary>
        /// 基本値を出力対象とするか
        /// アニメーションの途中でペインの位置などが変わってしまっている場合でも
        /// 時間=0のパラメータが出力されます
        /// </summary>
        public bool UseBaseValue { get; set; }

        /// <summary>
        /// サムネイルファイルを出力するか？
        /// </summary>
        public bool CreateThumbnail { get; set; }

        /// <summary>
        /// 一時ファイルの元のパス
        /// </summary>
        public string OriginalPath { get; set; } = string.Empty;
    }

    /// <summary>
    /// エクスポート処理を行うモジュールが実装すべきインタフェースです。
    /// </summary>
    internal interface IExporter : IFileInfoHolder
    {
        /// <summary>
        /// ファイルを出力します。
        /// </summary>
        bool DoSave( string outPath, SubScene targetScene );

        /// <summary>
        /// ログ出力などを受け取るクラスを設定します。
        /// </summary>
        LEMsgReporter    MsgReporter { set; }

        /// <summary>
        /// 保存オプションです。
        /// </summary>
        ExportOption ExportOption { get; set; }

        /// <summary>
        /// 出力するものが何もない場合は false を返すと、一切の処理がスキップされます。
        /// </summary>
        bool CheckNothingToExport(ISubScene scene);
    }
}
