﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Diagnostics;

namespace LECore.Manipulator
{
    using LECore.Structures;
    using LECore.Structures.Nsrif.Attributes;
    using LECore.Structures.Core.Command;
    using TexMtxCommandFactory = LECore.Structures.Core.Command.MementoCommandFactory<LECore.Structures.ITexMtx>;


    /// <summary>
    /// TexMtxManipulator の概要の説明です。
    /// </summary>
    public class TexMtxManipulator : BaseManipulator
    {
        // 操作対象
        TexMtx          _target = null;
        TexMtxCommandFactory _TexMtxCommandFactory;
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public TexMtxManipulator()
        {
            _TexMtxCommandFactory = new TexMtxCommandFactory( delegate( ITexMtx src ) { return new TexMtxMemento( src ); } );
        }

        /// <summary>
        /// 操作対象を設定します。
        /// </summary>
        /// <param name="targetTextBox"></param>
        public void BindTarget( ITexMtx targetTexMtx )
        {
            _target = targetTexMtx as TexMtx;
            Debug.Assert( _target != null );
        }

        /// <summary>
        /// S,R,T の Setプロパティ
        /// </summary>
        public FVec2     Scale
        {
            set
            {
                if( _target.Scale != value )
                {
                    ManipulatorUtility.ModifyAttrWithCreatingCmd(_target.ScaleAnmAttr, value);
                }
            }
        }
        public float     Rotate
        {
            set
            {
                if( _target.Rotate != value )
                {
                    ManipulatorUtility.ModifyAttrWithCreatingCmd(_target.RotateAnmAttr, value);
                }
            }
        }
        public FVec2     Trans
        {
            set
            {
                if( _target.Trans != value )
                {
                    ManipulatorUtility.ModifyAttrWithCreatingCmd(_target.TransAnmAttr, value);
                }
            }
        }

    }
}

