﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.IO;
using System.Diagnostics;

namespace LECore.Manipulator
{
    using LECore.Structures;
    using LECore.Save_Load;
    using LECore.Structures.Core.Command;
    using LECore.Structures.LECoreInterface;

    using RlytConverter = LECore.Save_Load.RlytConverter;
    using ScissorCommandFactory = LECore.Structures.Core.Command.MementoCommandFactory<LECore.Structures.IScissor>;

    /// <summary>
    /// TextBoxManipulator の概要の説明です。
    /// </summary>
    public class ScissorManipulator : BaseManipulator
    {
        /// <summary>
        ///
        /// </summary>
        static readonly RlytConverter _RlytConverter =
        new RlytConverter( string.Empty, LECore.LayoutEditorCore.MsgReporter );

        // 操作対象
        Scissor _target = null;

        /// <summary>
        /// Undoコマンド生成クラス。
        /// </summary>
        ScissorCommandFactory _commandFactory;

        /// <summary>
        /// 変更コマンドを登録しつつ、パラメータを更新します。
        /// 任意のValueChangeFunctionでパラメータを更新してください。
        /// </summary>
        void ValueChangeWithCommandRegister_(ScissorCommandFactory.InstanceModifyFunction valueChangeFunction )
        {
            _commandFactory.Modify(_target, valueChangeFunction );
        }

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public ScissorManipulator()
        {
            _commandFactory = new ScissorCommandFactory(delegate ( IScissor mementoSrc ){return new ScissorMemento( mementoSrc );});
        }

        /// <summary>
        /// 操作対象を設定します。
        /// </summary>
        /// <param name="targetScissor"></param>
        public void BindTarget( IScissor target)
        {
            _target = target as Scissor;
            Debug.Assert(_target != null );
        }

        /// <summary>
        /// 操作対象
        /// </summary>
        public IScissor IScissor
        {
            get{ return _target;}
        }
    }
}
