﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Diagnostics;

namespace LECore.Manipulator
{
    using LECore.Structures;
    using LECore.Structures.Nsrif.Attributes;
    using LECore.Structures.Core.Command;
    using LEGroupCommandFactory = LECore.Structures.Core.Command.MementoCommandFactory<LECore.Structures.ILEGroup>;


    /// <summary>
    /// GroupManipulator の概要の説明です。
    /// </summary>
    public class GroupManipulator : BaseManipulator
    {
        // 操作対象
        LEGroup          _target = null;
        LEGroupCommandFactory _LEGroupCommandFactory;
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public GroupManipulator()
        {
            _LEGroupCommandFactory = new LEGroupCommandFactory(
                delegate( ILEGroup src ){ return new LEGroupMemento( src ); } );
        }

        /// <summary>
        /// 操作対象を設定します。
        /// </summary>
        /// <param name="targetTextBox"></param>
        public void BindTarget( ILEGroup targetGroup )
        {
            _target = targetGroup as LEGroup;
            Debug.Assert( _target != null );
        }

        /// <summary>
        /// 名前を変更します。
        /// </summary>
        public string Name
        {
            set
            {
                if( _target.GrouprName != value )
                {
                    _LEGroupCommandFactory.Modify( _target, delegate()
                    {
                        _target.GrouprName = value;
                    } );
                }
            }
        }

        /// <summary>
        /// 名前を変更します。
        /// </summary>
        public string UserCommentString
        {
            set
            {
                if( _target.UserCommentString != value )
                {
                    _LEGroupCommandFactory.Modify( _target, delegate()
                    {
                        _target.UserCommentString = value;
                    } );
                }
            }
        }

        // メンバ登録、削除、順番入れ替えは GroupMgrManipulator 経由で行います。

    }
}



