﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using LECore.Structures.LECoreInterface;

namespace LECore.Manipulator
{
    using LECore.Structures;
    using LECore.Structures.Core.Command;
    using LECore.Structures.Nsrif.Attributes;

    using DropShadowCommandFactory = LECore.Structures.Core.Command.MementoCommandFactory<LECore.Structures.IDropShadow>;

    public class DropShadowManipulator : BaseManipulator
    {
        DropShadow _targetDropShadow = null;
        DropShadowCommandFactory _commandFactory;

        public DropShadowManipulator()
        {
            _commandFactory = new DropShadowCommandFactory
                (
                delegate (IDropShadow mementoSrc) { return new DropShadowMemento(mementoSrc); }
                );
        }

        public void BindTarget(IDropShadow targetDropShadow)
        {
            _targetDropShadow = targetDropShadow as DropShadow;
            System.Diagnostics.Debug.Assert(_targetDropShadow != null);
        }

        public IDropShadow IDropShadow
        {
            get
            {
                return _targetDropShadow;
            }
        }

        public bool IsKnockoutEnabled
        {
            set
            {
                if (_targetDropShadow.IsKnockoutEnabled != value)
                {
                    _commandFactory.Modify(_targetDropShadow, delegate ()
                    {
                        _targetDropShadow.IsKnockoutEnabled = value;
                    });
                }
            }
        }

        public bool IsOnlyEffectEnabled
        {
            set
            {
                if (_targetDropShadow.IsOnlyEffectEnabled != value)
                {
                    _commandFactory.Modify(_targetDropShadow, delegate ()
                    {
                        _targetDropShadow.IsOnlyEffectEnabled = value;
                    });
                }
            }
        }

        public bool IsStaticRenderingEnabled
        {
            set
            {
                if (_targetDropShadow.IsStaticRenderingEnabled != value)
                {
                    _commandFactory.Modify(_targetDropShadow, delegate ()
                    {
                        _targetDropShadow.IsStaticRenderingEnabled = value;
                    });
                }
            }
        }

        public bool IsStrokeEnabled
        {
            set
            {
                if (_targetDropShadow.IsStrokeEnabled != value)
                {
                    _commandFactory.Modify(_targetDropShadow, delegate ()
                    {
                        _targetDropShadow.IsStrokeEnabled = value;
                    });
                }
            }
        }

        public float strokeSize
        {
            set
            {
                if (_targetDropShadow.strokeSize != value)
                {
                    _commandFactory.Modify(_targetDropShadow, delegate ()
                    {
                        _targetDropShadow.strokeSize = value;
                    });
                }
            }
        }

        public DropShadowBlendMode strokeBlendMode
        {
            set
            {
                if (_targetDropShadow.strokeBlendMode != value)
                {
                    _commandFactory.Modify(_targetDropShadow, delegate ()
                    {
                        _targetDropShadow.strokeBlendMode = value;
                    });
                }
            }
        }

        public RGBAColor strokeColor
        {
            set
            {
                if (_targetDropShadow.strokeColor != value)
                {
                    _commandFactory.Modify(_targetDropShadow, delegate ()
                    {
                        _targetDropShadow.strokeColor = value;
                    });
                }
            }
        }

        public bool IsOuterGlowEnabled
        {
            set
            {
                if (_targetDropShadow.IsOuterGlowEnabled != value)
                {
                    _commandFactory.Modify(_targetDropShadow, delegate ()
                    {
                        _targetDropShadow.IsOuterGlowEnabled = value;
                    });
                }
            }
        }

        public DropShadowBlendMode outerGlowBlendMode
        {
            set
            {
                if (_targetDropShadow.outerGlowBlendMode != value)
                {
                    _commandFactory.Modify(_targetDropShadow, delegate ()
                    {
                        _targetDropShadow.outerGlowBlendMode = value;
                    });
                }
            }
        }

        public RGBAColor outerGlowColor
        {
            set
            {
                if (_targetDropShadow.outerGlowColor != value)
                {
                    _commandFactory.Modify(_targetDropShadow, delegate ()
                    {
                        _targetDropShadow.outerGlowColor = value;
                    });
                }
            }
        }

        public float outerGlowSpread
        {
            set
            {
                if (_targetDropShadow.outerGlowSpread != value)
                {
                    _commandFactory.Modify(_targetDropShadow, delegate ()
                    {
                        _targetDropShadow.outerGlowSpread = value;
                    });
                }
            }
        }

        public float outerGlowSize
        {
            set
            {
                if (_targetDropShadow.outerGlowSize != value)
                {
                    _commandFactory.Modify(_targetDropShadow, delegate ()
                    {
                        _targetDropShadow.outerGlowSize = value;
                    });
                }
            }
        }

        public bool IsDropShadowEnabled
        {
            set
            {
                if (_targetDropShadow.IsDropShadowEnabled != value)
                {
                    _commandFactory.Modify(_targetDropShadow, delegate ()
                    {
                        _targetDropShadow.IsDropShadowEnabled = value;
                    });
                }
            }
        }

        public DropShadowBlendMode dropShadowBlendMode
        {
            set
            {
                if (_targetDropShadow.dropShadowBlendMode != value)
                {
                    _commandFactory.Modify(_targetDropShadow, delegate ()
                    {
                        _targetDropShadow.dropShadowBlendMode = value;
                    });
                }
            }
        }

        public RGBAColor dropShadowColor
        {
            set
            {
                if (_targetDropShadow.dropShadowColor != value)
                {
                    _commandFactory.Modify(_targetDropShadow, delegate ()
                    {
                        _targetDropShadow.dropShadowColor = value;
                    });
                }
            }
        }

        public float dropShadowAngle
        {
            set
            {
                if (_targetDropShadow.dropShadowAngle != value)
                {
                    _commandFactory.Modify(_targetDropShadow, delegate ()
                    {
                        _targetDropShadow.dropShadowAngle = value;
                    });
                }
            }
        }

        public float dropShadowDistance
        {
            set
            {
                if (_targetDropShadow.dropShadowDistance != value)
                {
                    _commandFactory.Modify(_targetDropShadow, delegate ()
                    {
                        _targetDropShadow.dropShadowDistance = value;
                    });
                }
            }
        }

        public float dropShadowSpread
        {
            set
            {
                if (_targetDropShadow.dropShadowSpread != value)
                {
                    _commandFactory.Modify(_targetDropShadow, delegate ()
                    {
                        _targetDropShadow.dropShadowSpread = value;
                    });
                }
            }
        }

        public float dropShadowSize
        {
            set
            {
                if (_targetDropShadow.dropShadowSize != value)
                {
                    _commandFactory.Modify(_targetDropShadow, delegate ()
                    {
                        _targetDropShadow.dropShadowSize = value;
                    });
                }
            }
        }

        /// <summary>
        /// ドロップシャドウ効果用のキャプチャテクスチャを作成します。
        /// </summary>
        public void CreateCaptureTextureForDropShadow(IPane pane, ITextureMgr textureMgr)
        {
            _targetDropShadow.CreateCaptureTextureForDropShadow(pane, textureMgr);
        }
    }
}
