﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
//
// 3D エディタからコピーされたコードです。
//

using System;
using System.Diagnostics;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

namespace LECore
{
    /// <summary>
    /// デバッグコンソールクラス。
    /// </summary>
    public class DbgConsole : System.Windows.Forms.Form
    {
        #region デザイナ変数
        private System.Windows.Forms.TextBox tbxOutput;
        private System.ComponentModel.Container components = null;
        #endregion

        #region デザイナコード
        /// <summary>
        /// デザイナ サポートに必要なメソッドです。このメソッドの内容を
        /// コード エディタで変更しないでください。
        /// </summary>
        private void InitializeComponent()
        {
            this.tbxOutput = new System.Windows.Forms.TextBox();
            this.SuspendLayout();
            //
            // tbxOutput
            //
            this.tbxOutput.BackColor = System.Drawing.Color.Black;
            this.tbxOutput.Dock = System.Windows.Forms.DockStyle.Fill;
            this.tbxOutput.Font = new System.Drawing.Font("ＭＳ ゴシック", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(128)));
            this.tbxOutput.ForeColor = System.Drawing.Color.White;
            this.tbxOutput.Location = new System.Drawing.Point(0, 0);
            this.tbxOutput.Multiline = true;
            this.tbxOutput.Name = "tbxOutput";
            this.tbxOutput.ReadOnly = true;
            this.tbxOutput.ScrollBars = System.Windows.Forms.ScrollBars.Both;
            this.tbxOutput.Size = new System.Drawing.Size(292, 273);
            this.tbxOutput.TabIndex = 0;
            this.tbxOutput.Text = "";
            this.tbxOutput.WordWrap = false;
            //
            // DbgConsole
            //
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 12);
            this.ClientSize = new System.Drawing.Size(292, 273);
            this.Controls.Add(this.tbxOutput);
            this.Name = "DbgConsole";
            this.Text = "Debug Console";
            this.ResumeLayout(false);

        }
        #endregion

        // インスタンス
        private static DbgConsole _instance = null;

        /// <summary>
        /// 初期化処理。
        /// </summary>
        [Conditional("DEBUG")]
        public static void Initialize()
        {
            if (_instance == null)
            {
                _instance = new DbgConsole();
                _instance.Show();
                _instance.Update();
            }
        }

        /// <summary>
        /// 終了処理。
        /// </summary>
        [Conditional("DEBUG")]
        public static void Terminate()
        {
            if (_instance != null)
            {
                if (!_instance.IsHandleCreated)
                {
                    _instance.Close();
                }
            }
        }

        delegate void WriteMsgDelegate_( string message );

        /// <summary>
        /// 書き込み。
        /// </summary>
        public static void Write(string message)
        {
            if( _instance != null && _instance.IsHandleCreated )
            {
                if( _instance.InvokeRequired )
                {
                    _instance.BeginInvoke( new WriteMsgDelegate_( Write ), new object[] { message } );
                }
                else
                {

                    TextBox tbx = _instance.tbxOutput;

                    string numberedMsg = string.Format( "{0:d3} {1}", tbx.Lines.Length, message );

                    if( tbx.TextLength + numberedMsg.Length > tbx.MaxLength )
                    {
                        tbx.Clear();
                        numberedMsg = string.Format( "{0:d3} {1}", tbx.Lines.Length, message );
                    }
                    tbx.AppendText( numberedMsg );
                }
            }
        }

        /// <summary>
        /// 書式指定付き書き込み。
        /// </summary>
        [Conditional("DEBUG")]
        public static void Write(string format, params object[] args)
        {
            Write(string.Format(format, args));
        }

        /// <summary>
        /// 書き込み＋改行。
        /// </summary>
        [Conditional("DEBUG")]
        public static void WriteLine(string message)
        {
            Write(message + "\r\n");
        }

        /// <summary>
        /// 書式指定付き書き込み＋改行。
        /// </summary>
        [Conditional("DEBUG")]
        public static void WriteLine(string format, params object[] args)
        {
            Write(string.Format(format, args) + "\r\n");
        }

        /// <summary>
        /// 条件付き書き込み。
        /// </summary>
        [Conditional("DEBUG")]
        public static void WriteIf(bool condition, string message)
        {
            if (condition)
            {
                Write(message);
            }
        }

        /// <summary>
        /// 条件付き書式指定付き書き込み。
        /// </summary>
        [Conditional("DEBUG")]
        public static void WriteIf(bool condition, string format, params object[] args)
        {
            if (condition)
            {
                Write(format, args);
            }
        }

        /// <summary>
        /// 条件付き書き込み＋改行。
        /// </summary>
        [Conditional("DEBUG")]
        public static void WriteLineIf(bool condition, string message)
        {
            if (condition)
            {
                WriteLine(message);
            }
        }

        /// <summary>
        /// 条件付き書式指定付き書き込み＋改行。
        /// </summary>
        [Conditional("DEBUG")]
        public static void WriteLineIf(bool condition, string format, params object[] args)
        {
            if (condition)
            {
                WriteLine(format, args);
            }
        }

        #region オーバーライドメソッド
        /// <summary>
        /// 使用されているリソースに後処理を実行します。
        /// </summary>
        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                if (components != null)
                {
                    components.Dispose();
                }
            }
            base.Dispose(disposing);
        }
        #endregion

        #region オーバーライドイベント
        #region Load
        /// <summary>
        /// オーバーライドイベント。
        /// </summary>
        protected override void OnLoad(EventArgs e)
        {
            base.OnLoad(e);

            // 位置、サイズをデスクトップ隅に設定
            Rectangle desktop = Screen.PrimaryScreen.WorkingArea;
            Size      size    = new Size( desktop.Width / 2, desktop.Height / 6 );
            this.Location = new Point(desktop.Right - size.Width, desktop.Bottom - size.Height);
            this.Size     = size;
        }
        #endregion
        #endregion

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        private DbgConsole()
        {
            InitializeComponent();
        }
    }
}
