﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Diagnostics;

namespace LECore
{
    public static class WinFormsBuildUtility
    {
        static public bool IsDesignMode()
        {
            // デザインモードを判定する方法がかなり不確定のようで、下記のサイトを参考にしました。
            // http://www.geocities.jp/tinqwill/cs.html#deginer
            bool designMode = false;
            if (System.ComponentModel.LicenseManager.UsageMode == System.ComponentModel.LicenseUsageMode.Designtime)
            {
                designMode = true;
            }
            else if (Process.GetCurrentProcess().ProcessName.ToUpper().Equals("DEVENV") || Process.GetCurrentProcess().ProcessName.ToUpper().Equals("VCSEXPRESS"))
            {
                designMode = true;
            }
            else if (AppDomain.CurrentDomain.FriendlyName == "DefaultDomain")
            {
                designMode = true;
            }
            return designMode;
        }
    }
}
