﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/


// これは メイン DLL ファイルです。
#include "stdafx.h"
#include <malloc.h>
#include <new>

//#pragma warning(disable:4091)
//#include <msclr\lock.h>
//#pragma warning(default:4091)

#define NW4R_FROM_TOOL
#include "NW4RScFont.h"

#ifdef NW_LAYOUTEDITOR_CAFE
#include "FontEnvironment.h"
#include <scfont_ScalableFont.h>

namespace
{
    class MyAllocater : public nw::scfont::IAllocator
    {
        //---------------------------------------------------------------------------
        //! @brief メモリを確保します。
        //---------------------------------------------------------------------------
        virtual void* Alloc(size_t size, u32 alignment)
        {
            NW_UNUSED_VARIABLE(alignment);
            return malloc(size);
        }

        //---------------------------------------------------------------------------
        //! @brief メモリを解放します。
        //---------------------------------------------------------------------------
        virtual void  Free(void* memory)
        {
            return free(memory);
        }
    };

    static MyAllocater sMyAllocater;
}

namespace NW4R
{
namespace Font
{
       ScFont::ScFont()
       {
       }

       ScFont::~ScFont()
       {
       }

       ScFont::InitializeArg::InitializeArg()
       {
       }

       void ScFont::UpdateAndCompleteTheTextureCache()
       {
           m_TextureCache->UpdateTextureCache();
           m_TextureCache->CompleteTextureCache();

           UnManaged::TextureSize size = m_TextureCache->GetTextureObject()->GetSize();
           CopyTo32bitBmp_(m_TextureCache->GetTextureObject()->GetImage(), m_pSheetPropSet[0], size);
       }

       //---------------------------------------------------------

       void ScFont::CopyTo32bitBmp_(const void* pSrcPtr, INWFont::SheetPropaties^ pDstSheet, UnManaged::TextureSize size )
       {
           const u8* pSrc = (const u8*)pSrcPtr;
           u32* pDst = (u32*)pDstSheet->imgPtr.ToPointer();
           for(int y = 0; y < size.height;y++)
           {
               int invY = size.height -1 -y;
               for(int x = 0; x < size.width;x++)
               {
                   u8 src = pSrc[invY * size.width + x];
                   pDst[y * size.width + x] = (src) << 24|(255) << 16|(255) << 8|(255) << 0;
               }
           }
       }

       // 各グリフが参照するフォントイメージを表すテクスチャデータの配列を返します。
       array<INWFont::SheetPropaties^>^  ScFont::GetSheetPropaties()
       {
           return m_pSheetPropSet;
       }

       // ファイルロード結果バイト配列から、データを設定します。
       bool ScFont::SetResource(array<Byte>^  byteArray, ITextureConvertUtility^ platformDetail, bool isEndianSwapEnabled, Object^ paramater)
       {
           NW_UNUSED_VARIABLE(platformDetail);
           NW_UNUSED_VARIABLE(isEndianSwapEnabled);

           InitializeArg^ initArg = static_cast<InitializeArg^>(paramater);
           m_NativeFontResources = gcnew array<IntPtr>(1);
           m_NativeFontResources[0] = Marshal::AllocCoTaskMem(byteArray->Length);
           Marshal::Copy(byteArray, 0, m_NativeFontResources[0], byteArray->Length);

           initArg->fontDatas[0][0] = m_NativeFontResources[0];
           initArg->fontDataSizes[0][0] = byteArray->Length;

           this->Initialize(initArg);

           array<INWFont::SheetPropaties^>^   sheetPropSet = gcnew array<INWFont::SheetPropaties^>(1);
           sheetPropSet[0] = gcnew INWFont::SheetPropaties();

           UnManaged::TextureSize size = m_TextureCache->GetTextureObject()->GetSize();
           sheetPropSet[0]->imgPtr = Marshal::AllocCoTaskMem(size.width * size.height  *4 );
           sheetPropSet[0]->texWidth = m_TextureCache->GetTextureObject()->GetSize().width;
           sheetPropSet[0]->texHeight = m_TextureCache->GetTextureObject()->GetSize().height;

           m_pSheetPropSet = sheetPropSet;

           return true;
       }

       bool ScFont::SetResources( array<array<Byte>^>^ byteArrays, ITextureConvertUtility^ platformDetail, bool isEndianSwapEnabled, Object^ paramater )
       {
           NW_UNUSED_VARIABLE(platformDetail);
           NW_UNUSED_VARIABLE(isEndianSwapEnabled);

           int fontCount = byteArrays->Length;

           InitializeArg^ initArg = static_cast<InitializeArg^>(paramater);
           m_NativeFontResources = gcnew array<IntPtr>(fontCount);
           array<INWFont::SheetPropaties^>^   sheetPropSet = gcnew array<INWFont::SheetPropaties^>(1);

           for (int i = 0; i < fontCount; i++)
           {
               auto byteArray = byteArrays[i];
               m_NativeFontResources[i] = Marshal::AllocCoTaskMem(byteArray->Length);
               Marshal::Copy(byteArray, 0, m_NativeFontResources[i], byteArray->Length);

               initArg->fontDatas[0][i] = m_NativeFontResources[i];
               initArg->fontDataSizes[0][i] = byteArray->Length;

           }
           this->Initialize(initArg);

           sheetPropSet[0] = gcnew INWFont::SheetPropaties();

           UnManaged::TextureSize size = m_TextureCache->GetTextureObject()->GetSize();
           sheetPropSet[0]->imgPtr = Marshal::AllocCoTaskMem(size.width * size.height  *4 );
           sheetPropSet[0]->texWidth = m_TextureCache->GetTextureObject()->GetSize().width;
           sheetPropSet[0]->texHeight = m_TextureCache->GetTextureObject()->GetSize().height;
           m_pSheetPropSet = sheetPropSet;

           return true;
       }

       // リソース解除
       void ScFont::RemoveResource()
       {
           if (m_NativeFontResources != nullptr)
           {
               for (int i = 0; i < m_NativeFontResources->Length; i++)
               {
                   Marshal::FreeCoTaskMem(m_NativeFontResources[i]);
                   m_NativeFontResources[i] = IntPtr::Zero;
               }
           }

           if(m_pSheetPropSet != nullptr && m_pSheetPropSet[0] != nullptr)
           {
               Marshal::FreeCoTaskMem(m_pSheetPropSet[0]->imgPtr);
               m_pSheetPropSet[0]->imgPtr = IntPtr::Zero;
           }

           if (m_pFont != nullptr)
           {
               delete m_pFont;
               m_pFont = nullptr;
           }

           if (m_TextureCache != nullptr)
           {
               m_TextureCache->Finalize(&sMyAllocater);
               delete m_TextureCache;
               m_TextureCache = nullptr;
           }

           if (m_FontDatas)
           {
               for (int i = 0; i < m_FontDatas->Count; i++)
               {
                   delete[] (u8*)m_FontDatas[i].ToPointer();
               }
               m_FontDatas = nullptr;
           }
       }

       // private に変更する
       void ScFont::Initialize(ScFont::InitializeArg^ arg)
       {
           if (m_TextureCache == NULL)
           {
               if (m_FontDatas)
               {
                   for (int i = 0; i < m_FontDatas->Count; i++)
                   {
                       delete[] (u8*)m_FontDatas[i].ToPointer();
                   }
               }
               m_FontDatas = gcnew List<IntPtr>();
               m_TextureCache = new nw::scfont::TextureCache();
               nw::scfont::TextureCache::InitializeArg initArg;

               initArg.textureCacheWidth = arg->textureCacheWidth;
               initArg.textureCacheHeight = arg->textureCacheHeight;

               initArg.allocator = &sMyAllocater;

               auto fontCount = arg->fontDatas->Length;

               initArg.fontDatas = new void**[fontCount];
               initArg.fontDataSizes = new u32*[fontCount];
               initArg.fontDataTypes = new nw::scfont::TextureCache::FontDataType*[fontCount];
               initArg.boldWeights = new f32*[fontCount];
               initArg.borderWidths = new u8*[fontCount];
               initArg.scaleWidths = new f32*[fontCount];
               initArg.scaleHeights = new f32*[fontCount];
               initArg.ignorePalt = new bool*[fontCount];
               initArg.deleteBearingX = new bool*[fontCount];
               initArg.bearingOffsetX = new int*[fontCount];
               initArg.forceMonospacedEnabled = new bool*[fontCount];
               initArg.forceMonospacedWidth = new int*[fontCount];
               initArg.baselineOffset = new int*[fontCount];
               initArg.charCodeRangeCount = new int*[fontCount];
               initArg.charCodeRangeFirst = new u32**[fontCount];
               initArg.charCodeRangeLast = new u32**[fontCount];

               for (int i = 0; i < fontCount; i++)
               {
                   auto subFontCount = arg->fontDatas[i]->Length;
                   initArg.fontDatas[i] = new void*[subFontCount];
                   initArg.fontDataSizes[i] = new u32[subFontCount];
                   initArg.fontDataTypes[i] = new nw::scfont::TextureCache::FontDataType[subFontCount];
                   initArg.boldWeights[i] = new f32[subFontCount];
                   initArg.borderWidths[i] = new u8[subFontCount];
                   initArg.scaleWidths[i] = new f32[subFontCount];
                   initArg.scaleHeights[i] = new f32[subFontCount];
                   initArg.ignorePalt[i] = new bool[subFontCount];
                   initArg.deleteBearingX[i] = new bool[subFontCount];
                   initArg.bearingOffsetX[i] = new int[subFontCount];
                   initArg.forceMonospacedEnabled[i] = new bool[subFontCount];
                   initArg.forceMonospacedWidth[i] = new int[subFontCount];
                   initArg.baselineOffset[i] = new int[subFontCount];
                   initArg.charCodeRangeCount[i] = new int[subFontCount];
                   initArg.charCodeRangeFirst[i] = new u32*[subFontCount];
                   initArg.charCodeRangeLast[i] = new u32*[subFontCount];

                   for (int j = 0; j < subFontCount; j++)
                   {
                       int size = arg->fontDataSizes[i][j];
                       auto fontdata = new u8[size];
                       initArg.fontDatas[i][j] = fontdata;
                       m_FontDatas->Add((IntPtr)fontdata);
                       initArg.fontDataSizes[i][j] = size;
                       initArg.fontDataTypes[i][j] = static_cast<nw::scfont::TextureCache::FontDataType>(arg->fontTypes[i][j]);
                       initArg.boldWeights[i][j] = arg->fontBoldWeights[i][j];
                       initArg.borderWidths[i][j] = static_cast<u8>(arg->fontBorderSizes[i][j]);
                       initArg.scaleWidths[i][j] = arg->fontScaleWidths[i][j];
                       initArg.scaleHeights[i][j] = arg->fontScaleHeights[i][j];
                       initArg.ignorePalt[i][j] = arg->ignorePalt[i][j];
                       initArg.deleteBearingX[i][j] = arg->deleteBearingX[i][j];
                       initArg.bearingOffsetX[i][j] = arg->bearingOffsetX[i][j];
                       initArg.forceMonospacedEnabled[i][j] = arg->forceMonospacedEnabled[i][j];
                       initArg.forceMonospacedWidth[i][j] = arg->forceMonospacedWidth[i][j];
                       initArg.baselineOffset[i][j] = arg->baselineOffset[i][j];
                       initArg.charCodeRangeCount[i][j] = arg->charCodeRangeCount[i][j];
                       initArg.charCodeRangeFirst[i][j] = new u32[arg->charCodeRangeCount[i][j]];
                       initArg.charCodeRangeLast[i][j] = new u32[arg->charCodeRangeCount[i][j]];
                       for (int k = 0; k < arg->charCodeRangeCount[i][j]; k++)
                       {
                           initArg.charCodeRangeFirst[i][j][k] = arg->charCodeRangeFirst[i][j][k];
                           initArg.charCodeRangeLast[i][j][k] = arg->charCodeRangeLast[i][j][k];
                       }

                       memcpy_s(fontdata, size, arg->fontDatas[i][j].ToPointer(), size);
                   }
               }

               initArg.fontCount = fontCount;
               initArg.fontListCount = new u32[1];
               initArg.fontListCount[0] = arg->fontDatas[0]->Length;

               // 特定のフォントを読み込んだ際に、ワークメモリ不足からエラーとなってしまうので、多めに設定しておきます。(SIGLO-28417)(SIGLO-35451)
               initArg.workMemorySize = 1024 * 1024 * 4;
               initArg.noPlotWorkMemorySize = 1024 * 1024;

               m_TextureCache->Initialize(initArg);
           }

           {
               nw::scfont::ScalableFont* pScFont = new nw::scfont::ScalableFont();
               nw::scfont::ScalableFont::InitializeArg initArg;

               initArg.fontFace = arg->fontFace;
               initArg.fontSize = arg->fontSize;
               initArg.isAlternateCharSpaceWithOriginalWidth = arg->isAlternateCharSpaceWithOriginalWidth;
               initArg.isAlternateCharSpaceWithOriginalWidthForNotReadyChar = arg->isAlternateCharSpaceWithOriginalWidthForNotReadyChar;
               initArg.alternateChar = static_cast<uint32_t>(arg->alternateChar);
               initArg.lineFeedOffset = arg->lineFeedOffset;
               initArg.textureCache = m_TextureCache;

               pScFont->Initialize(initArg);
               m_pFont = pScFont;
           }
       }

       bool ScFont::RegisterGlyph(u16 code, s32 lockGroup)
       {
           //msclr::lock l(m_NativeFonrResources);
           bool isRegistered = m_TextureCache->RegisterGlyph(code, m_pFont->GetMaxCharWidth(), m_pFont->GetFontFace(), lockGroup);
           return isRegistered;
       }

       u32 ScFont::RegisterGlyphs(const u16* codes, s32 lockGroup)
       {
           return m_TextureCache->RegisterGlyphsWithLength((const char16*)codes, UINT_MAX, m_pFont->GetMaxCharWidth(), m_pFont->GetFontFace(), lockGroup);
       }

       u32 ScFont::RegisterGlyphsWithLength(const u16* codes, u32 codeLength, s32 lockGroup)
       {
           return m_TextureCache->RegisterGlyphsWithLength((const char16*)codes, codeLength, m_pFont->GetMaxCharWidth(), m_pFont->GetFontFace(), lockGroup);
       }

       void ScFont::ResetTextureCache()
       {
           //msclr::lock l(m_NativeFonrResources);
           m_TextureCache->ResetTextureCache();
       }

       void ScFont::ClearLockGlyphs(const u16* codes, s32 lockGroup)
       {
           m_TextureCache->ClearLockGlyphsWithLength((const char16*)codes, UINT_MAX, m_pFont->GetMaxCharWidth(), m_pFont->GetFontFace(), lockGroup);
       }

       void ScFont::ClearLockGlyphsWithLength(const u16* codes, u32 codeLength, s32 lockGroup)
       {
           m_TextureCache->ClearLockGlyphsWithLength((const char16*)codes, codeLength, m_pFont->GetMaxCharWidth(), m_pFont->GetFontFace(), lockGroup);
       }

       void ScFont::RegisterAlternateCharGlyph()
       {
           //msclr::lock l(m_NativeFonrResources);
           m_pFont->RegisterAlternateCharGlyph();
       }

       u16 ScFont::GetFontFace()
       {
           return m_pFont->GetFontFace();
       }

       bool ScFont::IsDrawMultiCore()
       {
           return false;
       }

       bool ScFont::IsGlyphPlot(u16 code)
       {
           return m_TextureCache->FindGlyphNode(code, m_pFont->GetMaxCharWidth(), m_pFont->GetFontFace()) != NULL;
       }

       bool ScFont::IsGlyphExistInFont(u16 code)
       {
           return m_TextureCache->IsGlyphExistInFont(code, m_pFont->GetFontFace());
       }

       void ScFont::SetGlyphUsed(u16 code)
       {
           UnManaged::Glyph glyph;
           m_pFont->GetGlyph(&glyph, code);
       }

       void ScFont::SetHeight(int height)
       {
           m_pFont->SetHeight(height);
       }

       void ScFont::SetBaselinePos(int pos)
       {
           m_pFont->SetBaselinePos(pos);
       }

       //---------------------------------------------------------

       int ScFont::GetBaselinePos()
       {
           return m_pFont->GetBaselinePos();
       }

       int ScFont::GetCellHeight()
       {
           return m_pFont->GetCellHeight();
       }

       // ピクセル単位でのセルの幅を返します。
       int ScFont::GetCellWidth()
       {
           return m_pFont->GetCellWidth();
       }

       // ピクセル単位でのフォントの高さを返します。
       int ScFont::GetHeight()
       {
           return m_pFont->GetHeight();
       }

       // ピクセル単位でのセルの幅を返します。
       int ScFont::GetWidth()
       {
           return m_pFont->GetWidth();
       }

       // フォントに含まれる最大の文字幅をピクセル単位で返します。
       // ソースデータ全体から算出される値のため、フィルタの影響を受けません。
       // = GetWidth()
       int ScFont::GetMaxCharWidth()
       {
           return m_pFont->GetMaxCharWidth();
           //return m_FontSize;
       }

       // フォントがもつ改行幅を設定します。
       // フォントの改行幅は TextWriter が 1 行の高さの基準として用いる値です。
       // この値はフォントの高さやセルの高さとは無関係です
       // （大小関係が定められていません）が、
       // fontcvtr はデフォルトではフォントの高さをフォントの改行幅として設定します。
       void ScFont::SetLineFeed( int linefeed )
       {
           m_pFont->SetLineFeed(linefeed);
       }

       // 初回描画時の初期化を行います。
       void ScFont::InitializeAtTheFirstTimeDraw()
       {
           // 何もしません。
       }

       UnManaged::Font* ScFont::GetUnManagedFont()
       {
           return m_pFont;
       }

       // 1行の高さを返します。
       int ScFont::GetLineFeed()
       {
           return m_pFont->GetLineFeed();
       }

       // エンコーディングの種類を返します。
       INWFont::FontEncoding   ScFont::GetEncoding()
       {
           return INWFont::FontEncoding::FONT_ENCODING_UTF16;
       }

       // カーニング情報を持つか取得します。
       bool ScFont::HasKerning()
       {
           return m_pFont->HasKerning();
       }

       // 縁付かきどうか取得します
       bool ScFont::IsBorderEffectEnabled()
       {
           return m_TextureCache->IsBorderEffectEnabled(m_pFont->GetFontFace());
       }

       // 描画準備完了か？
       bool ScFont::IsReadyToDraw()
       {
           return true;
       }
}
}

#endif // NW_LAYOUTEDITOR_CAFE
