﻿/*--------------------------------------------------------------------------------*
Copyright (C)Nintendo All rights reserved.

These coded instructions, statements, and computer programs contain proprietary
information of Nintendo and/or its licensed developers and are protected by
national and international copyright laws. They may not be disclosed to third
parties or copied or duplicated in any form, in whole or in part, without the
prior written consent of Nintendo.

The content herein is highly confidential and should be handled accordingly.
*--------------------------------------------------------------------------------*/

#pragma once

#include "NW4RFont.h"

//  意図した未使用変数に対するコンパイラ警告を抑制します。
#define NN_UNUSED( variable ) ( void )( variable )
namespace nn
{
    namespace font
    {
        class PairFont;
    }
}
namespace NW4R
{
namespace Font
{


    public ref class PairFont : public INWFont
    {
    private:
        nn::font::PairFont* m_pFont;

    public:
        PairFont(INWFont^ first, INWFont^ second);

        ~PairFont();

        INWFont^ FirstFont;
        INWFont^ SecondFont;

        // 各グリフが参照するフォントイメージを表すテクスチャデータの配列を返します。
        virtual array<INWFont::SheetPropaties^>^  GetSheetPropaties() override;

        // アンマネージドフォントを取得します。
        // NW4RTextWriter から利用されます。
        virtual UnManaged::Font* GetUnManagedFont() override;

        // ファイルロード結果バイト配列から、データを設定します。
        virtual bool SetResource(array<Byte>^  byteArray, ITextureConvertUtility^ platformDetail, bool isEndianSwapEnabled, Object^ paramater) override
        {
            NN_UNUSED(byteArray);
            NN_UNUSED(platformDetail);
            NN_UNUSED(isEndianSwapEnabled);
            NN_UNUSED(paramater);

            return false;
        }

        // ファイルロード結果バイト配列から、データを設定します。
        virtual bool SetResources(array<array<Byte>^>^  byteArrays, ITextureConvertUtility^ platformDetail, bool isEndianSwapEnabled, Object^ paramater) override
        {
            NN_UNUSED(byteArrays);
            NN_UNUSED(platformDetail);
            NN_UNUSED(isEndianSwapEnabled);
            NN_UNUSED(paramater);

            return false;
        }

        // リソース解除
        virtual void RemoveResource() override;

        // 初回描画時の初期化を行います。
        virtual void InitializeAtTheFirstTimeDraw() override;

        // ピクセル単位でのフォントの高さを返します。
        virtual int GetHeight() override;

        // ピクセル単位でのセルの幅を返します。
        virtual int GetWidth() override;

        // エンコーディングの種類を返します。
        virtual FontEncoding   GetEncoding() override;

        // カーニング情報を持つか取得します。
        virtual bool HasKerning() override;

        // パック形式か取得します。
        virtual bool IsPackedFormatFont() override;

        // 特殊フチ形式が設定可能かを取得します。
        virtual bool IsAvailableBorder() override;

        // SRGB フェッチが必要なフォーマットか取得します。
        virtual bool IsNeededToSrgbFetch() override;

        // 縁付きかどうか取得します
        virtual bool IsBorderEffectEnabled() override;

        // 描画準備完了か？
        virtual bool IsReadyToDraw() override;
    };

}
}
