﻿/*--------------------------------------------------------------------------------*
Copyright (C)Nintendo All rights reserved.

These coded instructions, statements, and computer programs contain proprietary
information of Nintendo and/or its licensed developers and are protected by
national and international copyright laws. They may not be disclosed to third
parties or copied or duplicated in any form, in whole or in part, without the
prior written consent of Nintendo.

The content herein is highly confidential and should be handled accordingly.
*--------------------------------------------------------------------------------*/
#include "NW4RPairFont.h"
#include "font_PairFont.h"
namespace NW4R
{
namespace Font
{
    PairFont::PairFont(INWFont^ first, INWFont^ second)
    {
        FirstFont = first;
        SecondFont = second;
        m_pFont = new nn::font::PairFont();
        m_pFont->SetFont(FirstFont->GetUnManagedFont(), SecondFont->GetUnManagedFont());
    }

    PairFont::~PairFont()
    {
        if (m_pFont != nullptr)
        {
            delete m_pFont;
            m_pFont = nullptr;
        }
    }

    // 各グリフが参照するフォントイメージを表すテクスチャデータの配列を返します。
    array<INWFont::SheetPropaties^>^ PairFont::GetSheetPropaties()
    {
        array<INWFont::SheetPropaties^>^ primary = FirstFont->GetSheetPropaties();
        array<INWFont::SheetPropaties^>^ secondary = SecondFont->GetSheetPropaties();
        array<INWFont::SheetPropaties^>^ merged = gcnew array<INWFont::SheetPropaties^>(primary->Length + secondary->Length);
        for (int i = 0; i < primary->Length; i++)
        {
            merged[i] = primary[i];
        }

        for (int i = 0; i < secondary->Length; i++)
        {
            merged[primary->Length + i] = secondary[i];
        }

        return merged;
    }

    void PairFont::RemoveResource()
    {
        SecondFont->RemoveResource();
        FirstFont->RemoveResource();
        if (m_pFont != nullptr)
        {
            delete m_pFont;
            m_pFont = nullptr;
        }
    }

    void PairFont::InitializeAtTheFirstTimeDraw()
    {
        FirstFont->InitializeAtTheFirstTimeDraw();
        SecondFont->InitializeAtTheFirstTimeDraw();
    }

    UnManaged::Font* PairFont::GetUnManagedFont()
    {
        return m_pFont;
    }

    // ピクセル単位でのフォントの高さを返します。
    int PairFont::GetHeight()
    {
        return m_pFont->GetHeight();
    }

    // ピクセル単位でのセルの幅を返します。
    int PairFont::GetWidth()
    {
        return m_pFont->GetWidth();
    }

    // エンコーディングの種類を返します。
    INWFont::FontEncoding   PairFont::GetEncoding()
    {
        INWFont::FontEncoding encoding = FirstFont->GetEncoding();
        if (encoding != SecondFont->GetEncoding())
        {
            // 不正扱いにしておく
            return INWFont::FontEncoding::NUM_OF_FONT_ENCODING;
        }

        return encoding;
    }

    // カーニング情報を持つか取得します。
    bool PairFont::HasKerning()
    {
        return m_pFont->HasKerning();
    }

    // 縁付きかどうか取得します
    bool PairFont::IsBorderEffectEnabled()
    {
        // FirstFont と SecondFont の値は同じでなければいけない
        return FirstFont->IsBorderEffectEnabled();
    }

    bool PairFont::IsPackedFormatFont()
    {
        // 両方で判定する
        return FirstFont->IsPackedFormatFont() && SecondFont->IsPackedFormatFont();
    }

    bool PairFont::IsAvailableBorder()
    {
        // 両方で判断する
        return FirstFont->IsAvailableBorder() && SecondFont->IsAvailableBorder();
    }

    bool PairFont::IsNeededToSrgbFetch()
    {
        // TODO: 不要ならメソッドを既定クラスから削除

        // 文字毎に設定するので、どちらでもいい
        return FirstFont->IsNeededToSrgbFetch() && SecondFont->IsNeededToSrgbFetch();
    }

    bool PairFont::IsReadyToDraw()
    {
        return FirstFont->IsReadyToDraw() && SecondFont->IsReadyToDraw();
    }
}
}
