﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <dolphin/types.h>
#include <nw/types.h>
#include "nw4r/misc.h"
#include "inlines.h"
//
// 移植の際に必要となった、数学関数を部分的に移植しました。
//

#ifdef NW4R_FROM_TOOL

namespace NW4R
{
namespace Font
{
namespace UnManaged
{

void DCFlushRange       ( void* addr, u32 nBytes )
{
    NW_UNUSED_VARIABLE(addr);
    NW_UNUSED_VARIABLE(nBytes);
    // DO NOTING! Dummy function.
}


}
}
}


namespace nw4r
{
    namespace math{
/*-------------------------------------------------------------------------*
  Name:         CntBit1(u32)

  Description:  ビット列の中で1となっているビットの数を数えます。

  Arguments:    x:  走査するビット列。

  Returns:      x 中で1となっているビットの数を返します。
 *-------------------------------------------------------------------------*/
// u32 CntBit1(u32 x)
//
// 説明： ビット列の中で 1 となっているビットの数を数えます。
// 引数： x: 対象のビット列
// 返値： ビット列の中で 1 となっているビットの数。
u32 CntBit1(u32 x)
{
    x = x - ((x >> 1) & 0x55555555);
    x = (x & 0x33333333) + ((x >> 2) & 0x33333333);
    x = (x + (x >> 4)) & 0x0f0f0f0f;
    x = x + (x >> 8);
    x = x + (x >> 16);
    return x & 0x0000003f;
}



/*-------------------------------------------------------------------------*
  Name:         CntBit1(const u32*, const u32*)

  Description:  ビット列の中で1となっているビットの数を数えます。

  Arguments:    first:  ビット列の先頭ワードへのポインタ。
                last:   ビット列の最終ワードの次のワードへのポインタ。

  Returns:      ビット列中で1となっているビットの数を返します。
 *-------------------------------------------------------------------------*/
// u32 CntBit1(const u32* first, const u32* last)
//
// 説明： ビット列の中で 1 となっているビットの数を数えます。
// 引数： first: ビット列の先頭ワードへのポインタ。
//          last:  ビット列の最終ワードの次のワードへのポインタ。
// 返値： ビット列の中で 1 となっているビットの数。
u32 CntBit1(const u32* first, const u32* last)
{
    const u32 n = u32(last - first);

    u32 i, j, lim;
    unsigned int s = 0;
    unsigned int ss, x;

    for (i = 0; i < n; i += 31)
    {
        lim = (n < i + 31) ? n : (i + 31);
        ss = 0;
        for (j = i; j < lim; ++j)
        {
            x = *(first + j);
            x -= ((x >> 1) & 0x55555555);
            x = (x & 0x33333333) + ((x >> 2) & 0x33333333);
            x = (x + (x >> 4)) & 0x0f0f0f0f;
            ss += x;
        }
        x = (ss & 0x00ff00ff) + ((ss >> 8) & 0x00ff00ff);
        x = (x & 0x0000ffff) + (x >> 16);
        s += x;
    }
    return s;
}

    }
}
#endif // NW4R_FROM_TOOL
