﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_CONFIG_PLATFORM_WIN32_H_
#define NW_CONFIG_PLATFORM_WIN32_H_

#include <stdio.h>

#if !defined(NW_RELEASE)
  #define NW_CONSOLE_ENABLE
#endif

#define NW_LITTLE_ENDIAN

// WIN32プラットフォームでは、リソースのエンディアンを全てひっくり返す
#define NW_UT_RES_SWAP_ENDIAN

#define NW_ENABLE_FLOAT64

// NOTE: WIN32 というマクロと Win32 というマクロが定義されているので、win32 にしておく
#define NW_PLATFORM_NAME   win32
#define NW_PLATFORM_WIN32

#define NW_HALT     do { int* a = NULL; *a = 1; } while ((void)0, 0);

#ifdef NW_FROM_TOOL

  #define NW_TLOG     printf
  #define NW_LOG      printf

#else

#if defined(NW_CONSOLE_ENABLE)
  #define NW_TLOG    ::nw::ut::TPrintf
  #define NW_LOG     ::nw::ut::Printf
#else
  #define NW_TLOG(...) ((void)0)
  #define NW_LOG(...)  ((void)0)
#endif

namespace nw {
namespace ut {
    void Printf(const char *fmt, ...);
    void TPrintf(const char *fmt, ...);
    void Panic( const char* fileName, int line, const char* fmt, ...);
    void TPanic( const char* fileName, int line, const char* fmt, ...);

    void HaltWithDetail(const char* codePos, int lineNo, const char* format, ...);
} // namespace ut

} // namespace nw
#endif // #ifdef NW_FROM_TOOL

/* NW_CONFIG_PLATFORM_WIN32_H_ */
#endif
