﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_CONFIG_COMPILER_H_
#define NW_CONFIG_COMPILER_H_

#if defined( __CC_ARM ) || defined( __ARMCC_VERSION )
  // ARM RealView Compiler.
  #define NW_COMPILER_RVCT
  #include <nw/config/compiler/rvct.h>

  #define NW_DEPRECATED_FUNCTION_MSG(MFunc, msg) MFunc __attribute__ ((deprecated))
  #define NW_CHECKED_ARRAY_ITERATOR(MIte, MNum) MIte
  #define NW_CHAR_TRAITS_COPY(MType, MDest, MDestSize, MFrom, MCount) std::char_traits<MType>::copy(MDest, MFrom, MCount)
  #define NW_WEAK_ATTRIBUTE
  #define NW_MISALIGNED
#elif defined( __CWCC__ ) || defined( __MWERKS__ )
  // Freescale CodeWarrior
  #define NW_COMPILER_CWCC
  #include <nw/config/compiler/cwcc.h>

  #define NW_DEPRECATED_FUNCTION_MSG(MFunc, msg) MFunc
  #define NW_CHECKED_ARRAY_ITERATOR(MIte, MNum) MIte
  #define NW_CHAR_TRAITS_COPY(MType, MDest, MDestSize, MFrom, MCount) std::char_traits<MType>::copy(MDest, MFrom, MCount)
  #define NW_WEAK_ATTRIBUTE
  #define NW_MISALIGNED

#elif defined( __ghs__ )
  // Green Hills Software
  #define NW_COMPILER_GHS
  #include <nw/config/compiler/ghs.h>

  #define NW_DEPRECATED_FUNCTION_MSG(MFunc, msg) MFunc __attribute__ ((deprecated))
  #define NW_CHECKED_ARRAY_ITERATOR(MIte, MNum) MIte
  #define NW_CHAR_TRAITS_COPY(MType, MDest, MDestSize, MFrom, MCount) std::char_traits<MType>::copy(MDest, MFrom, MCount)
  #define NW_WEAK_ATTRIBUTE __attribute__((weak))
  #define NW_MISALIGNED __packed

#elif defined( __GNUC__ )
  // GNU C++
  #define NW_COMPILER_GCC
  #include <nw/config/compiler/gcc.h>

  #define NW_DEPRECATED_FUNCTION_MSG(MFunc, msg) MFunc __attribute__ ((deprecated))
  #define NW_CHECKED_ARRAY_ITERATOR(MIte, MNum) MIte
  #define NW_CHAR_TRAITS_COPY(MType, MDest, MDestSize, MFrom, MCount) std::char_traits<MType>::copy(MDest, MFrom, MCount)
  #define NW_WEAK_ATTRIBUTE __attribute__((weak))
  #define NW_MISALIGNED

#elif defined( _MSC_VER )
  // Miscrosoft Visual C++
  #define NW_COMPILER_MSVC
  #include <nw/config/compiler/msvc.h>

  #define NW_DEPRECATED_FUNCTION_MSG(MFunc, msg) __declspec(deprecated(msg)) MFunc
  #define NW_CHECKED_ARRAY_ITERATOR(MIte, MNum) stdext::make_checked_array_iterator(MIte, MNum)
  #define NW_CHAR_TRAITS_COPY(MType, MDest, MDestSize, MFrom, MCount) std::char_traits<MType>::_Copy_s(MDest, MDestSize, MFrom, MCount)
  #define NW_WEAK_ATTRIBUTE
  #define NW_MISALIGNED

#else

  #error "Unknown compiler"

#endif

#define NW_DEPRECATED_FUNCTION(MFunc) NW_DEPRECATED_FUNCTION_MSG(MFunc, "## Deprecated function ##")

#if defined(NW_DOCUMENTATION)
  #undef NW_DEPRECATED_FUNCTION
  #define NW_DEPRECATED_FUNCTION(MFunc) \
  /*! @details :deprecated */ MFunc
  #undef NW_DEPRECATED_FUNCTION_MSG
  #define NW_DEPRECATED_FUNCTION_MSG(MFunc, msg) \
  /*! @details :deprecated */ MFunc
#endif

#ifndef NW_NO_THROW
  #define NW_NO_THROW
#endif


/* NW_CONFIG_COMPILER_H_ */
#endif
