﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW4R_UT_BINARYFILEFORMAT_H_
#define NW4R_UT_BINARYFILEFORMAT_H_

#include <nw4r/config.h>
#include <dolphin/types.h>

/* ------------------------------------------------------------------------
        マクロ定義
   ------------------------------------------------------------------------ */

//---- シグネチャ作成マクロ

#ifdef NW4R_LITTLE_ENDIAN

 //---- little endian
 #define NW4R_UT_MAKE_SIGWORD(a,b,c,d)        \
    static_cast<NW4R::Font::UnManaged::SigWord >(        \
          (static_cast<u8>(a) <<  0)        \
        | (static_cast<u8>(b) <<  8)        \
        | (static_cast<u8>(c) << 16)        \
        | (static_cast<u8>(d) << 24)        \
    )

 #define NW_UT_MAKE_VERSION(major, minor, micro, binaryBugFix)            \
    static_cast<u32>(                                                    \
        (static_cast<u8>(major) <<  0) | (static_cast<u8>(minor) << 8)  \
      | (static_cast<u8>(micro) << 16) | (static_cast<u8>(binaryBugFix << 24)) \
    )
#else

 //---- big endian
 #define NW4R_UT_MAKE_SIGWORD(a,b,c,d)        \
    static_cast<NW4R::Font::UnManaged::SigWord >(        \
          (static_cast<u8>(a) << 24)        \
        | (static_cast<u8>(b) << 16)        \
        | (static_cast<u8>(c) <<  8)        \
        | (static_cast<u8>(d) <<  0)        \
    )

 //---- バージョン作成マクロ
 #define NW_UT_MAKE_VERSION(major, minor, micro, binaryBugFix)            \
    static_cast<u32>(                                                    \
        (static_cast<u8>(major) << 24) | (static_cast<u8>(minor) << 16)  \
      | (static_cast<u8>(micro) <<  8) | (static_cast<u8>(binaryBugFix)) \
    )
#endif

namespace NW4R
{
namespace Font
{
namespace UnManaged
{


/* ------------------------------------------------------------------------
        型定義
   ------------------------------------------------------------------------ */

//---- シグネチャ型
typedef u32 SigWord;



/*---------------------------------------------------------------------------*
  Name:         BinaryFileHeader

  Description:  NintendoWare 標準バイナリファイルヘッダ
 *---------------------------------------------------------------------------*/
struct BinaryFileHeader
{
#if 0
    SigWord signature;                  // ファイルシグネチャ
    u16     byteOrder;                  // バイトオーダーマーク
    u16     padding;
    u32     version;                    // ファイルバージョン
    u32     fileSize;                   // ファイルサイズ
    u16     headerSize;                 // ヘッダサイズ
    u16     dataBlocks;                 // ブロック数
#else

    SigWord signature;                  // ファイルシグネチャ
    u16     byteOrder;                  // バイトオーダーマーク
    u16     headerSize;                 // ヘッダサイズ
    u32     version;                    // ファイルバージョン
    u32     fileSize;                   // ファイルサイズ
    u16     dataBlocks;                 // ブロック数
    u16     reserved;
#endif
};



/*---------------------------------------------------------------------------*
  Name:         BinaryBlockHeader

  Description:  NintendoWare 標準バイナリブロックヘッダ
 *---------------------------------------------------------------------------*/
struct BinaryBlockHeader
{
    SigWord kind;                       // ブロック種別名
    u32     size;                       // ブロック全体サイズ
};



/* ------------------------------------------------------------------------
        定数定義
   ------------------------------------------------------------------------ */

namespace
{
#ifdef NW4R_LITTLE_ENDIAN
    const u16 BYTE_ORDER_MARK = 0xFFFE;
#else
    const u16 BYTE_ORDER_MARK = 0xFEFF;
#endif
}





/* ------------------------------------------------------------------------
        関数プロトタイプ
   ------------------------------------------------------------------------ */

bool IsValidBinaryFile(
                const BinaryFileHeader* header,
                u32                     signature,
                u32                     version,
                u16                     minBlocks   = 1 );

enum BinaryFileValidateCode
    {
        Valid = 0,
        InvalidSignature = 1,
        InvalidByteOrderMark = 2,
        InvalidVersion = 3,
        InvalidFileSize = 4,
        InvalidBlockSize = 5,
        UnknownInvalid = -1,
    };

BinaryFileValidateCode ValidateBinaryFile( const BinaryFileHeader* header,
                                           u32                     signature,
                                           u32                     signature2,
                                           u32                     version,
                                           u16                     minBlocks   = 1 );

bool IsReverseEndianBinaryFile( const BinaryFileHeader* header );

BinaryBlockHeader* GetNextBinaryBlockHeader(
    BinaryFileHeader* fileHeader,
    BinaryBlockHeader* blockHeader
);

        } /* UnManaged */
    } /* namespace ut */
} /* namespace nw4r */
#endif //  NW4R_UT_BINARYFILEFORMAT_H_
