﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW4R_UT_TAGPROCESSORBASE_H_
#define NW4R_UT_TAGPROCESSORBASE_H_

#include <dolphin/types.h>
#include "Rect.h"

namespace NW4R
{
namespace Font
{
namespace UnManaged
{



template <typename CharType>
class TextWriterBase;


template <typename CharType>
struct PrintContext
{
    TextWriterBase<CharType>*   writer;     // 文字描画に使用しているTextWriterへのポインタ
    const CharType*             str;        // 描画中の文字列へのポインタ
    const float                 xOrigin;    // 描画開始X座標
    const float                 yOrigin;    // 描画開始Y座標
    u32                         flags;      // TextWriter::ContextFlag のOR。
    u16							prevCode;	// ひとつ前の文字。カーニングの値を求めるために使用します。

    // コンストラクタ
    PrintContext(
        TextWriterBase<CharType>*   writer,
        const CharType*             str,
        const float                 xOrigin,
        const float                 yOrigin,
        u32                         flags,
        u16                         prevCode)
        :writer(writer)
        ,str(str)
        ,xOrigin(xOrigin)
        ,yOrigin(yOrigin)
        ,flags(flags)
        ,prevCode(prevCode)
    {
    }

    PrintContext& operator=(const PrintContext& other)
    {
        // 代入は想定されていません。
        NW_ASSERT(false);
    }
};



template <typename CharType>
class TagProcessorBase
{
public:
    /* ------------------------------------------------------------------------
            型
       ------------------------------------------------------------------------ */
    typedef CharType                CharType;
    typedef PrintContext<CharType>  ContextType;

    enum Operation
    {
        OPERATION_DEFAULT,          // 通常の文字処理を行います
        OPERATION_NO_CHAR_SPACE,    // 次の文字との間に文字間を空けません
        OPERATION_CHAR_SPACE,       // 次の文字との間に文字間を開けます
        OPERATION_NEXT_LINE,        // 描画フラグと現在位置以降の文字列に応じてX座標を調整します
        OPERATION_END_DRAW,         // 文字列の描画処理を終了します
        NUM_OF_OPERATION
    };

    /* ------------------------------------------------------------------------
            関数
       ------------------------------------------------------------------------ */
    //---- コンストラクタ/デストラクタ
                        TagProcessorBase();
    virtual             ~TagProcessorBase();

    //---- タグ処理
    virtual Operation   Process(u16 code, ContextType* context);
    virtual Operation   CalcRect(Rect* pRect, u16 code, ContextType* context);

private:
    void                ProcessLinefeed(ContextType* context);
    void                ProcessTab(ContextType* context);
};




} /* UnManaged */
} /* namespace ut */
} /* namespace nw4r */

#endif //  NW4R_UT_TAGPROCESSORBASE_H_
