﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW4R_UT_RESFONT_H_
#define NW4R_UT_RESFONT_H_


#include <dolphin/types.h>
#include "ResFontBase.h"
#include "ByteSwapUtil.h"


namespace NW4R
{
namespace Font
{
namespace UnManaged
{


class ResFont
    : public detail::ResFontBase
{
public:
    /* ------------------------------------------------------------------------
            関数
       ------------------------------------------------------------------------ */
    //---- コンストラクタ/デストラクタ
                                ResFont();
    virtual                     ~ResFont();

    //---- リソース
    bool                        SetResource(void* brfnt, bool isEndianSwapEnabled);
    void*                       RemoveResource();




private:

    /* ------------------------------------------------------------------------
            変数
       ------------------------------------------------------------------------ */

    FontSwapUtil                mFontSwapUtil;



    /* ------------------------------------------------------------------------
            関数
       ------------------------------------------------------------------------ */
    //---- リソース再構築
    FontInformation*     Rebuild( BinaryFileHeader* fileHeader);  // brfntファイル先頭

    //! @brief      ブロックを探します。
    //!
    //! @param[in]  fileHeader  メモリ上にロードしたbffntファイルの
    //!                             ファイルヘッダへのポインタ
    //!
    //!
    //! @return     見つかった場合はそのポインタを返します。見つからなかった場合は
    //! 			NULLを返します。
    //!
    void* FindBlock(BinaryFileHeader* fileHeader, SigWord sigword);
};





} /* UnManaged */
} /* namespace ut */
} /* namespace nw4r */

#endif //  NW4R_UT_COLOR_H_
